﻿using System;
using System.Timers;
using System.Windows.Forms;

namespace RPi_CS
{
    public partial class Form1 : Form
    {
        System.Timers.Timer recTimer;
        int connectf = 0;                  // ネットワーク接続状態  -1:異常 0:接続準備中 1:接続完了
        int iTimeOut = 0;                  // 受信待ち
        const int portini = 17909;         // ソケット番号先頭値 (ラズベリーパイと一致させる)
        const int portlast = 17912;        // ソケット番号最終値
        int port;                          // ソケット番号接続値
 
        // ネットワーク関連
        System.Net.Sockets.TcpClient tcp;
        System.Net.Sockets.NetworkStream ns;

        public Form1()
        {
            InitializeComponent();
            this.Text = "ラズベリーパイ USBデバイスサーバー 送受信サンプル";

            port = portini;                        // ポート番号を先頭値にセット
            textBoxT.Text = "接続処理中 お待ちください";

            recTimer = new System.Timers.Timer();  // レスポンス受信処理用のタイマーをセット
            recTimer.Enabled = true;
            recTimer.AutoReset = true;
            recTimer.Interval = 10;
            recTimer.Elapsed += new ElapsedEventHandler(OnTimerEvent);

            ControlBox = false;                    // 閉じるボタンを無効にする
            CheckForIllegalCrossThreadCalls = false; // 別スレッドでテキストボックス変更を可能とする
            textBoxK.Focus();
        }

        // ラズベリーパイに接続

        private void RPiConnect()
        {
            try
            {
                string ipOrHost = "raspberrypi";   // raspberrypi ホスト名
                tcp = new System.Net.Sockets.TcpClient(ipOrHost, port); // TcpClientを作成、サーバーと接続
            }
            catch
            {
                connectf = -1;                     // 接続失敗とする
                textBoxT.Text = "サーバー接続異常";
            }
            if (connectf == 0)                     // サーバ接続が正常終了のとき
            {
                ns = tcp.GetStream();              // NetworkStreamを取得する

                // **** NET Framework 2.0以上が必要 ****
                if (port == portini)
                {
                    ns.ReadTimeout  = 2000;        // 読取りタイムアウト2秒
                    ns.WriteTimeout = 2000;        // 書込みのタイムアウト2秒
                }
                else{
                    ns.ReadTimeout  = 200;
                    ns.WriteTimeout = 200;
                }

                byte[] data = new byte[16];
                data[0] = 28;                      // 接続確認用データ
                data[1] = 13;
                ns.Write(data, 0, 2);              // 接続確認用データを送信

                int rxSize;
                rxSize = 0;
                try                                // 接続確認用応答データを受信
                {
                    rxSize = ns.Read(data, 0, 16); // データ受信
                }
                catch
                {
                }
                if ((rxSize == 2) && (data[0] == 29) && (data[1] == 13))
                {                                  // 応答ありのとき
                    connectf = 1;                  // 接続完了とする
                    textBoxT.Text = "接続完了";
                }
                else                               // 応答がないとき
                {                                  // ほかのクライアントが使用中で待たされている
                    textBoxT.Text = "接続継続";
                    data[0] = 42;                  // 待ちが解除となったときに
                    data[1] = 13;                  //       接続終了とするためのデータ
                    ns.Write(data, 0, 2);          // 接続終了用データを送信
                    ns.Close();                    // ネットワーク接続終了
                    tcp.Close();
                    port++;                        // ソケットを次の番号にする
                    if (port > portlast)           // 最後の番号になった？
                    {
                        connectf = -1;             // 接続失敗とする
                        textBoxT.Text = "最大接続数オーバー";
                    }
                }
            }
        }

        // レスポンス受信処理 (タイマーイベント)
        
        private void OnTimerEvent(object source, ElapsedEventArgs e)
        {
            recTimer.Stop();                       // タイマー停止

            // ラズベリーパイ(ホスト)に接続する処理

            if (connectf == 0)                     // 接続指示のとき
            {
                RPiConnect();                      // ラズベリーパイに接続
                if (connectf != -1) recTimer.Start();   // タイマー開始
                return;
            }

            // ラズベリーパイからデータを受信する処理

            byte[] rxdata = new byte[16384];
            int rxSize;
            rxSize = 0;
            try
            {
                rxSize = ns.Read(rxdata, 0, 16000);   // データ受信
            }
            catch
            {
                if (iTimeOut == 1) textBoxR.Text = "受信タイムアウト";
            }
            if(rxSize > 0) textBoxR.Text = System.Text.Encoding.ASCII.GetString(rxdata);
                                                   // 受信データ表示
            iTimeOut = 0;                          // 受信待ちを解除

            recTimer.Start();                      // タイマー開始
        }

        // コマンド送信処理 (キーを押したとき)

        private void textBoxK_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (connectf <= 0) return;             // 接続試行中または接続異常のときはなにもしない

            if (e.KeyCode == Keys.Return)          // Enter キーを押したとき
            {
                recTimer.Stop();                   // タイマー停止

                // キー入力した文字列をバイト配列にして、最後にCRコードを追加する

                byte[] data = System.Text.Encoding.ASCII.GetBytes(textBoxK.Text + "\r");
                ns.Write(data, 0, data.Length);    // データ送信

                textBoxT.Text = textBoxK.Text;     // 送信データ表示
                textBoxR.Text = "";
                textBoxK.Text = "";

                iTimeOut = 1;                      // 受信待ちとする
                recTimer.Start();                  // タイマー開始
            }

            if (e.KeyCode.ToString() == "D1")      // !(感嘆符)キーを押したとき (通常は使用しない)
            {
                connectf = 4;                      // 終了時にラズベリーパイの制御プログラム停止を指定
            }
            if (e.KeyCode.ToString() == "D3")      // #キーを押したとき (通常は使用しない)
            {
                connectf = 8;                      // 終了時にラズベリーパイのシャットダウンを指定
            }
        }

        // 終了処理
        
        private void button3_Click(object sender, EventArgs e)
        {
            recTimer.Stop();                       // タイマー停止

            if (connectf > 0)                      // 接続が完了しているとき
            {
                byte[] data = new byte[256];
                if (connectf == 1) data[0] = 42;   // *(アスタリスク)を送信して接続終了をホストに通知する
                else
                {
                    if (connectf == 4) data[0] = 33;  // !(感嘆符)を送信してラズベリーパイの制御プログラムを終了する
                    else               data[0] = 35;  // #を送信してラズベリーパイのシャットダウンをする
                }
                data[1] = 13;
                ns.Write(data, 0, 2);              // 接続終了用データを送信

                ns.Close();                        // ネットワーク接続終了
                tcp.Close();
            }
            this.Close();                          // プログラム終了
        }
    }
}
