# CRP25KB_out

# カウンタ計測ソフト CPR25KB と連携して、ファイル出力にてデジタル出力を指定する
#     ファイル CPR25KBDO.csv にデジタル出力データを書込む

# キー入力にて16進数6桁のデジタル出力データを指定
#     例 A1BD78(enter)   先頭文字 bit23--20  -->  6文字目 bit3--0
#     0～9、A～F 以外の文字を指定した場合は、該当文字部分のデジタル出力変更なし

# ファイル CPR25KBDO.csv をOPENするときの注意
#     (1) カウンタ計測ソフト CPR25KB が読込中のことがあるので、
#         例外(error)処理が必要。
#     (2) open -> write 後に、必ず(すみやかに) close すること。

import time

while True:
    data = input('keyin = ')      # キー入力データを読込む
    if len(data) < 6:             # 6文字未満のときは、再度キー入力
        continue
    else:
        data = data[0:6]          # 1文字目から6文字目までを有効とする
        print('Dout : '+data)     # デジタル出力データを表示
    while True:
        try:
            fp = open('CPR25KBDO.csv', 'wt')  # ファイル CPR25KBDO.csv をopen
        except:
            time.sleep(0.04)      # open できないとき
            continue              # 40ms 後に再試行
        else:
            fp.write(data+'\n')   # open できたとき、ファイルにデータを書込む
            fp.close()            # ファイルをclose
            break                 # キー入力へ戻る
