# DACS-2500KB カウンタ サンプルプログラム

# Windows11/10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# Dcnt_sample.py、Dcnt.py、FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# Dcnt_sample.py を起動すると
# カウント値読取りコマンドを自動送信し、
# 6チャンネル分のカウント値を読取って連続表示します。
# ホールド値読取りコマンドを自動送信し、
# 6チャンネル分のホールド値を読取って連続表示します。

# 以下のキー入力後、enterにて指示データを送信
# /(スラッシュ)で複数の指示データを連結可能  例 0R/0G/1R/1G
#          x:チャンネル番号(0～5)
#     xG  カウント開始
#     xS  カウント停止(電源投入初期)
#     xR  カウント値リセット
#     xF,zzz  フィルタ設定   zzz 小数点可 単位μs
#     xAB A相/B相カウント
#     xUD up/downカウント(電源投入初期)
#     xR1 カウントリセット入力有効(電源投入初期)
#     xR0 カウントリセット入力無効(例 ch0ではDI02)
#     xT1 ゲート入力有効
#     xT0 ゲート入力無効(電源投入初期)
#     xMI 周期計測
#     xMW パルス幅計測
#     xMN 通常カウント動作(電源投入初期)
#     xEC,z--z  最終値設定(10進数)  くり返し動作
#     xES,z--z  最終値設定(10進数)  最終値で停止
#     xEN 最終値設定解除(電源投入初期)
#     DI,y--y デジタル入力極性(16進数6桁 bit23～0)
#     DL1 デジタル出力(bit11～0)  カウンタ用出力に変更
#     DL0 デジタル出力(bit11～0)  汎用出力用途(初期)
#     DH1 デジタル出力(bit23～16) カウンタ用出力(カウンタ使用時)
#     DH0 デジタル出力(bit23～16) 汎用出力用途に変更
#     DO,y--y デジタル出力(16進数6桁 bit23～0)

# -(マイナス) enter にてプログラム終了

import msvcrt
import time
import Dcnt

# デバイスをOPEN、カウンタボードを確認
ret = Dcnt.Dcnt_init(9)
if ret[0] == 'OK':
    handle = ret[1]     # デバイスハンドルをセット
    print('OK')
else:
    print('no device')
    time.sleep(3)
    exit()

disp1 = ' |   ch0     |     1     |     2     |     3     |     4     |     5     |'

print(disp1)            # カウンタ番号0～5を画面表示

# カウント値またはホールド値の画面表示を繰返す
while True:
    time.sleep(0.01)

    for lcnt in range(2):
        if lcnt == 0:   # 6チャンネル分のカウント値を取得
            readdata = Dcnt.Dcnt_read(handle, '9')
            sdata = 'C'
        else:           # 6チャンネル分のホールド値を取得
            readdata = Dcnt.Dcnt_read(handle, '9H')
            sdata = 'H'
        if len(readdata) != 0:           # 正常データのとき
            pdata = readdata.split(',')  # ',' で分離
            for cnt in range(6):         # 1行に連結
                sdata = sdata + ' '*(12-len(pdata[cnt])) + pdata[cnt]
        else:                            # 不正データのとき
            sdata = 'data error'+' '*64
            time.sleep(2)
        print(sdata)                     # 表示
    if not msvcrt.kbhit():               # キー入力のないとき
        print('\033[3A')                 # 表示ラインを3行戻す
        continue

    # キー入力があったとき
    kydatabuf = input()
    # マイナスキー入力のときは終了
    if kydatabuf == '-':
        break
    if len(kydatabuf) != 0:
        # 指示データ送信
        readdata = Dcnt.Dcnt_write(handle, kydatabuf)
        # 応答結果を表示
        if readdata == 'OK':
            print(readdata)
        else:
            print('\033[31m'+kydatabuf+'-->'+readdata+'\033[0m')
    # カウンタ番号を表示
    print(disp1) 

# デバイスをCLOSE
Dcnt.Dcnt_close(handle)
