# DACS-2500K-RCP24 PWMパルス出力 サンプルプログラム

# Windows10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# d15rcp.py と FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# d15RCP.py を起動すると

# Aグループ、Bグループ共に以下の初期設定をします。
#    パルス出力の周波数
#    全チャンネルのパルス幅
#    パルス出力の開始

# キー操作にて任意のチャンネルのパルス幅を変更できます。
# A,x,y--y(enter) Aグループ指定
#            x : 0～11 チャンネル番号
#            y--y : ±パルス数(中心位置からのパルス幅偏移量)
#            ,y--y を省略すると表示チャンネル変更のみ
# B,x,y--y(enter) Bグループ指定

# 上記の操作にて指定したチャンネルのパルス幅とデジタル入力状態を
# 連続して表示します。
#    表示例 A xch width= aaaa   DI=FFFFFF   B xch width= bbbb
#    x : 上記操作で指定したチャンネル
#    aaaa : Aグループのパルス幅   bbbb : Bグループのパルス幅
#    FFFFFF : デジタル入力状態 16進数表示

# デジタル入力により、Aグループのパルス幅を増減操作できます。
#    操作対象チャンネルは上記操作で指定したチャンネルとなります。
#    デジタル入力lowにて増減します。
#    この機能が不要の場合は、変数 pmen = 0 としてください。
#
#    デジタル入力の読取り周期ごとに下記パルス幅を増減します。
#        デジタル入力bit0  +1
#                    bit1  +2
#                      ---
#                    bit7  +128
#        デジタル入力bit8  -1
#                    bit9  -2
#                      ---
#                    bit15 -128

# W0000000(enter)などのコマンド文字列入力にて
#    デバイスを操作することができます。

# enter のみをキー入力するとプログラムが終了します。

import FT
import msvcrt
from msvcrt import getch
import time

# パルス幅制限値、中心位置、初期位置を準備
#   Aグループ ch0 --> ch11 の順
pwalow  = [560,560,560,560,560,560,560,560,560,560,560,560]             # 最小値
pwahigh = [2480,2480,2480,2480,2480,2480,2480,2480,2480,2480,2480,2480] # 最大値
pwacent = [1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520] # 中心値
pwalist = [1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520] # 初期位置
#   Bグループ ch12 --> ch23 の順
pwblow  = [560,560,560,560,560,560,560,560,560,560,560,560]             # 最小値
pwbhigh = [2480,2480,2480,2480,2480,2480,2480,2480,2480,2480,2480,2480] # 最大値
pwbcent = [1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520] # 中心値
pwblist = [1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520,1520] # 初期位置

# デバイスをOPEN
handle = FT.init_dacs(0)
if handle.value == None:
    print('no device')
    exit()

# 周波数を初期設定 (内部カウントクロック 1MHz / パルス周波数 50Hz)
#   Aグループ ch0-->ch11
readdata = FT.transfer_dacs(handle, 'Q0B04E1F' + chr(0xd), 9)
if len(readdata) != 9:      # 最初の通信でPWMボードの確認
    FT.close_dacs(handle)   # 受信エラーのとき終了
    print('data error')
    exit()
#   Bグループ ch12-->ch23
readdata = FT.transfer_dacs(handle, 'Q0B14E1F' + chr(0xd), 9)

#   Aグループ パルス幅送信
for cnt in range(12):
    readdata = FT.transfer_dacs(handle, 'Q000'+format(cnt,'x')+("{:03x}".format(pwalist[cnt]))+chr(0xd),9)
#   Bグループ パルス幅送信
for cnt in range(12):
    readdata = FT.transfer_dacs(handle, 'Q001'+format(cnt,'x')+("{:03x}".format(pwblist[cnt]))+chr(0xd),9)

# パルス出力開始
#   Aグループ
readdata = FT.transfer_dacs(handle, 'Q000F000' + chr(0xd), 9)
#   Bグループ
readdata = FT.transfer_dacs(handle, 'Q001F000' + chr(0xd), 9)
print('PWM output start')

# デジタル入力によるパルス幅の増減操作
pmch = 0         # Aグループ操作対象チャンネル
accf = 0         # パルス幅増減値
pmen = 1         # 操作有効
pbch = 0         # Bグループ表示チャンネル

# コマンドコードのリスト(キー入力チェック用)
comlist = ['W','Q','q','I','y']

# パルス幅送信とキー入力による操作
while True:
    time.sleep(0.01)

    # キー入力があったときの処理
    if msvcrt.kbhit():
        print('')

        kydatabuf = input()
        kydata = kydatabuf.split(',')      # ',' で分離
        c1 = (kydata[0])[0:1]              # 最初の1文字

        # コマンド文字列の場合
        if c1 in comlist and len(kydata[0]) > 1:
            # キー入力データを送信し応答を受信
            tdata = kydata[0] + chr(0xd)
            readdata = FT.transfer_dacs(handle, tdata, 0)
            print(readdata)                # 応答を画面表示
            continue

        # enterのみのときは終了
        elif len(kydata[0]) == 0:
            break

        # 先頭がAまたはB
        elif (c1 == 'A' or c1 == 'a') and len(kydata[0]) == 1:
            tdata = 'Q000'                 # Aグループ
        elif (c1 == 'B' or c1 == 'b') and len(kydata[0]) == 1:
            tdata = 'Q001'                 # Bグループ
        else:
            print('invalid data')
            continue

        # パルス幅を算出
        try:
            n = int(kydata[1], 10)         # チャンネル番号を整数に変換
        except:
            print('invalid data')
            continue
        if n > 11 or n < 0:
            print('invalid data')
            continue
        if len(kydata) == 2:
            if tdata == 'Q000':            # Aグループ
                pmch = n                   # パルス幅増減操作対象チャンネル設定のみ
            else:                          # Bグループ
                pbch = n                   # パルス幅表示チャンネル設定のみ
            continue
        try:
            s = int(kydata[2], 10)         # センターからの位置を整数に変換
        except:
            print('invalid data')
            continue

        if tdata == 'Q000':                # Aチャンネルのとき
            p = pwacent[n] + s             # 実際のパルス幅に変換
            if p < pwalow[n]:              # 最小値の制限
                p = pwalow[n]
            if p > pwahigh[n]:             # 最大値の制限
                p = pwahigh[n]
            pwalist[n] = p                 # パルス幅を変更
            pmch = n                       # パルス幅増減操作対象チャンネルを設定
            # 送信文字列準備
            tdata = tdata + format(n,'x') + ("{:03x}".format(pwalist[n])) + chr(0xd)

        else:                              # Bチャンネルのとき
            p = pwbcent[n] + s             # 実際のパルス幅に変換
            if p < pwblow[n]:              # 最小値の制限
                p = pwblow[n]
            if p > pwbhigh[n]:             # 最大値の制限
                p = pwbhigh[n]
            pwblist[n] = p                 # パルス幅を変更
            pbch = n                       # 表示チャンネルを設定
            # 送信文字列準備
            tdata = tdata + format(n,'x') + ("{:03x}".format(pwblist[n])) + chr(0xd)

        # パルス幅を送信
        readdata = FT.transfer_dacs(handle, tdata, 9)
        if len(readdata) != 9:
            print('data error')            # 正常な応答がないときは終了
            break

    # キー入力がないとき
    else:
        # 送信文字列準備
        tdata = 'Q000' + format(pmch,'x') + ("{:03x}".format(pwalist[pmch])) + chr(0xd)
        # パルス幅を送信
        readdata = FT.transfer_dacs(handle, tdata, 9)

        if len(readdata) != 9 or readdata[0:1] != 'R':
            # エラーのとき、コマンドを送信し、残留データを読み切る
            time.sleep(1)
            readdata = FT.transfer_dacs(handle, 'W0000000'+chr(0xd), 0)
            if len(readdata) < 9:          # それでも応答がないとき
                print("")
                print('time-out error')
                break;                     # ループを終了
            else:
                continue;                  # 応答があればループを継続

        # 正常にデータを受信したとき

        if pmen == 1:                      # 増減操作有効のとき
            distate = int(readdata[6:8],16)    # 受信したデジタル入力(bit3-0)を整数に
            accf = (distate ^ 0xff)            # 論理を反転しパルス幅の増方向に
            distate = int(readdata[4:6],16)    # 受信したデジタル入力(bit7-4)を整数に
            accf = accf - (distate ^ 0xff)     # 論理を反転しパルス幅の減方向に

            pwalist[pmch] = pwalist[pmch] + accf   # パルス幅を更新
            if pwalist[pmch] > pwahigh[pmch]:
                pwalist[pmch] = pwahigh[pmch]      # パルス幅最大値
            if pwalist[pmch] < pwalow[pmch]:
                pwalist[pmch] = pwalow[pmch]       # パルス幅最小値

        # 状態を画面表示(パルス幅増減対象チャンネル、パルス幅、デジタル入力の順)

        sdata = 'A '+format(pmch,'d')+'ch width='+("{:5d}".format(pwalist[pmch]))+'   DI='+readdata[2:8] 
        sdata = sdata + '   B '+format(pbch,'d')+'ch width='+("{:5d}".format(pwblist[pbch]))
        print(sdata,end='\r')

# デバイスをCLOSE
FT.close_dacs(handle)
