# DACS-2500KB PWMパルス出力 24ch版 サンプルプログラム

# Windows11/10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# Drsw24_sample.py、Drsw24.py、FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# Drsw24_sample.py を起動すると
# PWMパルス幅読取りコマンドを自動送信し、
#   24チャンネル分のパルス幅(単位:クロック数)を読取って、
#   24チャンネルのパルス幅変化状態と共に連続表示します。

# 以下のキー入力後、enterにて指示データを送信
# /(スラッシュ)で複数の指示データを連結可能  例 W,0,100/W,1,200/G

#     Gx      パルス出力開始  G:全チャンネル  G1:グループ1  G2:グループ2
#     Nx      パルス出力終了  N:全チャンネル  N1:グループ1  N2:グループ2
#     I,y--y,z--z  周期設定
#             y--y  クロック周波数設定(MHz) 下記のいずれか
#                    0.5, 1, 2, 4, 8, 16, 32, 64
#             z--z  周期設定 小数点可 (単位: μs)
#     IP,y--y,z--z  周期設定
#             y--y  クロック周波数設定(MHz) 下記のいずれか
#                    0.5, 1, 2, 4, 8, 16, 32, 64
#             z--z  周期設定 (単位: クロック数)
#     W,xx,y--y  目標パルス幅設定
#             xx   チャンネル番号 (0～23)  全チャンネル指定(24)
#             y--y パルス幅 小数点可 (単位: μs)
#     WP,xx,y--y  目標パルス幅設定
#             xx   チャンネル番号 (0～23)  全チャンネル指定(24)
#             y--y パルス幅 (単位: クロック数)
#     V,xx,y--y  変化速度設定
#             xx   チャンネル番号 (0～23)  全チャンネル指定(24)
#             y--y 変化速度 小数点可 (単位: パルス幅 μs / s)
#               V,xx,R  速度変化リセット(直ちに指定パルス幅に)
#     VP,xx,y--y  変化速度設定
#             xx   チャンネル番号 (0～23)  全チャンネル指定(24)
#             y--y 変化速度 (単位: クロック数 / s)
#               VP,xx,R  速度変化リセット(直ちに指定パルス幅に)
#     Sx      パルス幅変化停止  S:全チャンネル  S1:グループ1  S2:グループ2
#               停止後のパルス幅を目標パルス幅とし、停止を解除
#     DP,y--y デジタル出力極性(16進数6桁 bit23～0)
#     DO,y--y デジタル出力(16進数6桁 bit23～0)

# 0～23 を入力してパルス幅 μs 表示チャンネルを指定します
# -(マイナス) enter にてプログラム終了

# L/z--z/xx,y--y/xx,y--y/  --  /x,y--y   同時スタート&ストップ
#     z--z  変化速度 (単位: μs / s) 小数点可
#     xx    チャンネル番号 0～23
#     y--y  目標パルス幅 (単位: μs) 小数点可
#     対象となるチャンネルのデータを /（スラッシュ）で連結
# LP/z--z/xx,y--y/xx,y--y/  --  /x,y--y  同時スタート&ストップ
#     z--z  変化速度 (単位: クロック数 / s)
#     xx    チャンネル番号 0～23
#     y--y  目標パルス幅 (単位: クロック数)
#     対象となるチャンネルのデータを /（スラッシュ）で連結

import msvcrt
import time
import Drsw24
import shutil           # ターミナルサイズ取得用

terminal_size = shutil.get_terminal_size()
if terminal_size.columns < 90:      # ターミナル横サイズが不足
    print('check terminal_size ---->')
    time.sleep(3)
    exit()

# デバイスをOPEN、PWMパルス出力ボードを確認
ret = Drsw24.Drsw24_init(9)
if ret[0] == 'OK':
    handle = ret[1]     # デバイスハンドルをセット
    print('OK')
else:
    print('no device')
    time.sleep(3)
    exit()

interclk = 99.0                     # クロック周波数設定(MHz)(未設定値)
internum = 20000                    # 周期(クロック数)
inters   = 20000.0                  # 周期(μs)
dispch   = 0                        # パルス幅表示チャンネル
print('clock= ***MHz   interval= ***.**us')
disp1 = '|ch0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |  9 | 10 | 11 | s |  DI  |'
print(disp1 + ' ch0')               # チャンネル番号0～11を画面表示
print('')                           # 1行空ける
disp2 = '| 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21 | 22 | 23 | s |'
print(disp2)                        # チャンネル番号12～23を画面表示
print('\033[3A')                    # 表示ラインを3行戻す

# 24チャンネル分のパルス幅 画面表示を繰返す
while True:
    time.sleep(0.01)

    # パルス幅を取得
    readdata = Drsw24.Drsw24_read(handle, '24')
    # パルス幅変化状態とデジタル入力を取得
    sreaddata = Drsw24.Drsw24_sread(handle)

    # 24チャンネル分のパルス幅とステータスを表示
    if len(readdata) == 119 and len(sreaddata) == 13:  # 正常データのとき
        pdata = readdata.split(',')  # ',' で分離
        sdata = ''
        for cnt in range(12):        # 0～11チャンネルを1行に連結
            sdata = sdata + ' ' + pdata[cnt]
        qdata = sreaddata.split(',') # ',' で分離
        sdata = sdata + ' ' + qdata[0][3:6] + ' ' + qdata[1]
        if interclk > 90:            # クロック周波数/周期未設定のとき
            sdata = sdata + ' ***.**us'
        else:                        # 表示指定チャンネルのパルス幅(μs)
            p = float(int(pdata[dispch],16))/interclk
            if p > 100.0:
                ii = format(p,'.2f')
            else:
                ii = format(p,'.3f')
            sdata = sdata + ' ' + ii
            if p > inters:
                sdata = sdata + ' over'  # パルス幅が周期を超えている
            elif int(pdata[dispch],16) == 0xffff:
                sdata = sdata + ' limit' # パルス幅上限
            else:
                sdata = sdata + 'us'     # 正常なパルス幅範囲
        print(sdata + '     ')       # 0～11チャンネルを表示
        print('')                    # 1行下へ
        sdata = ''
        for cnt in range(12):        # 12～23チャンネルを1行に連結
            sdata = sdata + ' ' + pdata[cnt+12]
        sdata = sdata + ' ' + qdata[0][0:3]
        print(sdata)                 # 12～23チャンネルを表示
        print('\033[4A')             # 表示ラインを4行戻す
    else:                            # 不正データのとき
        print('data error' + ' '*70)
        time.sleep(2)
    if not msvcrt.kbhit():           # キー入力のないとき
        continue

    # キー入力があったとき
    print('')                        # 3行下へ
    print('')
    print('')
    kydatabuf = input()
    # マイナスキー入力のときは終了
    if kydatabuf == '-':
        break
    if len(kydatabuf) != 0:
        # パルス幅表示チャンネルの指定
        c1 = kydatabuf[0:1]
        if c1 >= '0' and c1 <= '9':
            try:
                dch = int(kydatabuf)
            except ValueError:
                dch = 99
            if dch >= 0 and dch < 24:
                dispch = dch
            else:
                print('\033[31m'+kydatabuf+'-->'+'NG'+'\033[0m')
        else:
            # 同時スタート&ストップ
            if c1.upper() == 'L':
                readdata = Drsw24.Drsw24_pmove(handle, kydatabuf)
            # 指示データ送信
            else:
                readdata = Drsw24.Drsw24_write(handle, kydatabuf)
            # 応答結果を表示
            if readdata == 'OK':
                print(readdata)
            else:
                print('\033[31m'+kydatabuf+'-->'+readdata+'\033[0m')

    # クロック周波数、周期を表示
    ret = Drsw24.Drsw24_iread()
    interclk = ret[0]               # クロック周波数設定(MHz)
    internum = ret[1]               # 周期(クロック数)
    if interclk > 90.0:             # クロック周波数/周期未設定のとき
        print('clock= ***MHz   interval= ***.**us')
    else:                           # クロック周波数/周期設定済のとき
        inters = float(internum)/interclk    # 周期(μs)
        print('clock = ' + format(interclk,'.1f') + 'MHz',end='')
        if inters > 100.0:
            ii = format(inters,'.2f')
        else:
            ii = format(inters,'.3f')
        print('   interval = '+ ii + 'us  ' + format(internum,'05x'))
    # チャンネル番号を表示
    print(disp1 + ' ch' + format(dispch,'d')) 
    print('')
    print(disp2) 
    print('\033[3A')                # 表示ラインを3行戻す
    continue

# デバイスをCLOSE
Drsw24.Drsw24_close(handle)
