# DACS-2500KB デジタル入出力 サンプルプログラム
# ID番号を使用したボード識別

# Raspberry pi の Python にて動作
# DACS USBデバイスドライバをインストール済とします。
# Ddio_rpi_IDsample.py、Ddio_rpi.py、FT_rpi.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# Ddio_rpi_IDsample.py を起動すると
# ID番号のキー入力待ちになります。
# 指定したID番号のボードが見つかると、
#     指示データのキー入力待ちになります。

# 以下のキー入力後、enterにて指示データを送信
#     DW,y--y
#        y--y デジタル出力(16進数6桁 bit23～0)
#        デジタル入力(16進数6桁 bit23～0)を受信して表示
#     DR デジタル出力は変化なし
#        デジタル入力(16進数6桁 bit23～0)を受信して表示
# その他の操作詳細は、Ddio.py 関数の注釈をご覧ください。

# -(マイナス) enter にてプログラム終了

import Ddio_rpi

# デバイスをOPEN、デジタル入出力ボードを確認
while True:
    IDnum = input('ID = ')  # ID番号を入力
    if IDnum == '-':        # マイナスキー入力のときは終了
        exit()
    ret = Ddio_rpi.Ddio_initID(IDnum) # 指定番号のボードを検索
    if ret[0] == 'OK':
        handle = ret[1]     # デバイスハンドルをセット
        print('OK')
        break
    else:
        print('no device')

# キー入力とコマンド送信を繰返す
while True:
    kydatabuf = input()                  # 最初のenterキーまで無効
    # マイナスキー入力のときは終了
    if kydatabuf == '-':
        break
    # コマンド送信
    readdata = Ddio_rpi.Ddio_write(handle, kydatabuf)
    # 応答結果を表示
    if len(readdata) != 0:
        print(readdata)
    else:
        print('data error')
    continue

# デバイスをCLOSE
Ddio_rpi.Ddio_close(handle)
