import ctypes
import time

# 関数 デバイスの初期化
#     引数   : デバイス番号(int型)
#     戻り値 : デバイスハンドル

def init_dacs26(devnum):
    dll = ctypes.CDLL('FTD2xx.dll')
    hdl = ctypes.c_void_p()                       # デバイスハンドルの準備
    res = dll.FT_Open(ctypes.c_uint(devnum), ctypes.pointer(hdl))
    if res == 0:                                  # 正常にOPENできたとき
        res = dll.FT_SetTimeouts(hdl, 100, 100)   # タイムアウト時間(msec)を指定
    return hdl

# 関数 データ送信と応答受信
#     引数1  : デバイスハンドル
#     引数2  : 送信データ(int)  0～255    タイムアウト時間 7.5s
#              負データのときは送信なしで受信のみ   タイムアウト時間 50ms
#     戻り値 : 受信データ(int)  0～255  タイムアウトのとき -1

def transfer_dacs26(hdl, wdata):
    dll = ctypes.CDLL('FTD2xx.dll')

    # データ送信
    if wdata >= 0:
        wbuff = ctypes.c_byte(wdata & 0xff) # 送信データをC言語の１バイトデータとする
        wrnum = ctypes.c_ulong(0)           # 送信したデータ数の格納場所を準備
        # 送信実行
        res = dll.FT_Write(hdl, ctypes.pointer(wbuff), 1, ctypes.pointer(wrnum))

    # データ受信
    rbuff = ctypes.c_byte(0)         # 受信したデータの格納場所を準備

    for cnt in range(50):
        time.sleep(0.05)             # 少し待つ(50ms)
        rdnum = ctypes.c_ulong(0)    # 受信したデータ数の格納場所を準備
        # 受信実行
        res = dll.FT_Read(hdl, ctypes.pointer(rbuff), 1, ctypes.pointer(rdnum))

        if rdnum.value == 1:
            rdata = rbuff.value      # 受信したバイトデータをintに変換
            if rdata < 0:            # bit8 がONのときの処理
                rdata = rdata + 0x100
            break
        if wdata < 0:                # 受信のみの指定のときは、1回で終了
            break

    if rdnum.value == 0:
        rdata = -1                   # タイムアウトのとき
    return rdata

# 関数 デバイスのclose
#     引数   : デバイスハンドル
#     戻り値 : 正常終了のとき0

def close_dacs26(hdl):
    dll = ctypes.CDLL('FTD2xx.dll')
    return dll.FT_Close(hdl)
