/* DACS-2600p fW^o̓TvvO  2013/8/23 */
package jp.dacs_giken.dacsusbsample;

import android.os.Bundle;
import android.app.Activity;
import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;

import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;

public class DacsUsbSample extends Activity implements OnEditorActionListener {  // main

	private EditText _editText;        // L[͕\
	private TextView _sendView;        // Mf[^\
	private TextView _recView;         // Mf[^܂̓foCXڑԕ\
	
	D2xxManager ftD2xx;                // FTDI D2XX hCo
	FT_Device dacsDev = null;          // DACS foCX
    int devCount = 0;                  // foCXڑ (̃vO1݂̂ɑΉ)
	int inable = 0;                    // hCoMĂoCg
    public static final int RBUF_SIZE  = 16;  // Mf[^ǎobt@TCY(byte)
	byte[] rbuf;                       // Mf[^ǎobt@(bytez)
	int recnum = 0;                    // Mf[^ǎoCg
	
	public boolean bReadThreadGoing = false;   // ǎ菈
	public readThread read_thread;     // ǎ菈Xbh

	/**** ʕ\̏ƃfoCXOPEN ****/
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
    	super.onCreate(savedInstanceState);
    	setContentView(R.layout.activity_dacs_usb_sample);
    	_editText = (EditText)findViewById(R.id.edit_message); // L[͕\
    	_editText.setOnEditorActionListener(this);
    	_sendView = (TextView)findViewById(R.id.textViewsend); // Mf[^\
    	_recView = (TextView)findViewById(R.id.textViewrec);   // Mf[^\
	    rbuf = new byte[RBUF_SIZE];                            // Mf[^ǎobt@
	    
        try {
        	ftD2xx = D2xxManager.getInstance(this);       // hCõCX^X쐬
            devCount = ftD2xx.createDeviceInfoList(this); // foCXXg擾
            if(devCount > 0) {                            // foCX1ȏ̂Ƃ
           	    dacsDev = ftD2xx.openByIndex(this, 0);    // foCXCfbNXɂOPEN
            }
            else {
            	_recView.setText("foCXȂ");             // foCXȂƂ̃bZ[W
            	return;
            }
            if(dacsDev.isOpen()) {                  // foCXOPENłƂ
            	dacsDev.setBitMode((byte) 0, D2xxManager.FT_BITMODE_RESET); // 샂[hݒ
         		dacsDev.purge((byte) (D2xxManager.FT_PURGE_TX | D2xxManager.FT_PURGE_RX));
         		                                    // hCȏMobt@ɂ
                dacsDev.restartInTask();            // hCo̎M^XNN
             	_recView.setText("OPENł܂");    // bZ[W\
   				read_thread = new readThread();     // ǎ菈Xbh쐬
   				read_thread.start();                // ǎ菈XbhJn
   				bReadThreadGoing = true;            // ǎ菈-->쒆
            }    	
            else {                                  // OPENłȂƂ
            	_recView.setText("OPENG[ 2");      // G[bZ[W\
            }
        }
        catch (D2xxManager.D2xxException ex) {      // G[
         	if(dacsDev != null){
         		if(dacsDev.isOpen()) dacsDev.close(); // foCXclose
         	}
        	_recView.setText("OPENG[ 1");          // G[bZ[W\
        }
    }

    /**** f[^MƎMf[^ǎ菈 ****/
    
    public boolean onEditorAction(TextView textview, int id, KeyEvent keyEvent) { // GO(enter)L[Ƃ̏

    	String s = _editText.getText().toString();  // L[͕擾
    	if(s.length() > 0){                         // ͕1ȏ̂Ƃ͑Ms
    	    if(dacsDev == null) {                   // foCXڑȂ̂Ƃ
           	    _sendView.setText("Mł܂");    // G[bZ[W\
   		        return true;
            }
    	    recnum = 0;                             // Mf[^ǎoCgZbg
   	        byte[] writeByte = new byte[16];        // Mf[^obt@
   	        try {
   	        	int j = Integer.valueOf(s);         // ͕𐮐ɕϊ
   	        	writeByte[0] = (byte)(j & 0xff);
   	        } catch(NumberFormatException e) {
           	    _sendView.setText("f[^sł");  // G[bZ[W\
   		        return true;
   	        }
			synchronized(dacsDev) {
     		    dacsDev.purge((byte) (D2xxManager.FT_PURGE_TX | D2xxManager.FT_PURGE_RX));
     		                                        // Mobt@NA
                dacsDev.write(writeByte, 1);        // Ms
    			s = Integer.toString((int)writeByte[0] & 0xff) + "  ("+ Integer.toHexString((int)writeByte[0] & 0xff) +" Hex)";
    			                                    // \p10i16iɕϊ
			}
	   	    _sendView.setText(s);                   // Mf[^\
   	        int ec = 0;
   	        do{
				try {
					Thread.sleep(5);                // 5msX[v
				} catch (InterruptedException e) {
                    e.printStackTrace();
				}
				ec++;
				if(ec > 1000) break;                // ^CAEĝƂ[vʂ
   	        }while(recnum < 1);                     // Mf[^1ɂȂ܂Ń[v
   	        String t;
   	        if(ec > 1000) t = "^CAEgG[";        // ^CAEĝƂG[bZ[W
   	        else{
   	        	int i = 0xff & (int)rbuf[0];        // ɎMłƂ(擪1bytêݗLƂ)
	            t = Integer.toString(i) + "  (" + Integer.toHexString(i) + " Hex)";
	                                                // Mf[^10i16iɕϊ
     	 	    t = t + " < " + ec*5 + "ms" + " > "; // MԂ\
   	        }
   	        _recView.setText(t);                    // Mf[^\(^CAEĝƂ̓G[bZ[W)
    	}
    	else {                                      // L[͕Pȉ̂Ƃ̓vOI
		    bReadThreadGoing = false;               // ǎ菈Ԃ~Ƃ
    	    if(dacsDev != null){
    	    	if(dacsDev.isOpen()) dacsDev.close(); // foCXclose
    	    }
    	    this.finish();                          // vOI
    	}
    	return true;
    }
    
    /**** Mf[^ǎ菈Xbh ****/
    
	private class readThread extends Thread {
		@Override
		public void run() {
			while(bReadThreadGoing == true) {       // ǎ菈Ԃ̂Ƃ
				try {
					Thread.sleep(5);                // 5msX[v
				} catch (InterruptedException e) {
                    e.printStackTrace();
				}
				synchronized(dacsDev) {
					inable = dacsDev.getQueueStatus();  // MĂf[^mF
					if(inable > RBUF_SIZE) inable = RBUF_SIZE; // ǎoCg𐧌
					if (inable > 0) recnum = dacsDev.read(rbuf, inable); // ǎs
				}
			}
		}

	}
}
    

