﻿using System;
using System.Timers;
using System.Windows.Forms;
using FTD2XX_NET;       // 参照設定に FTD2XX_NET.dll を登録し、この1行を追加する

namespace DacsE350TTY
{
    public partial class Form1 : Form
    {
        uint DevNum = 0;
        FTD2XX_NET.FTDI ftDev = new FTDI();
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;
        System.Timers.Timer recTimer;
        int iTimeOut = 0;

        public Form1()
        {
            InitializeComponent();
            this.Text = "DACS-E350 USB送受信サンプル";

            ftDevOpenE350();                           // DACS-E350をOPEN, 制御プログラム起動処理
            if (DevNum == 1)
            {
                recTimer = new System.Timers.Timer();  // レスポンス受信処理用のタイマーをセット
                recTimer.Enabled = true;
                recTimer.AutoReset = true;
                recTimer.Interval = 10;
                recTimer.Elapsed += new ElapsedEventHandler(OnTimerEvent);
            }
            else
            {
                textBoxT.Text = "デバイス接続なし";
            }
            ControlBox = false;                        // 閉じるボタンを無効にする
            CheckForIllegalCrossThreadCalls = false;   // 別スレッドでテキストボックス変更を可能とする
            textBoxK.Focus();
        }

        // DACS-E350をOPEN, 制御プログラム起動処理
        
        private void ftDevOpenE350()
        {
            // DACS-E350をOPEN

            ftDev.GetNumberOfDevices(ref DevNum);     // ** 接続デバイス数を取得 **

            if (DevNum != 0)                          // 接続デバイスがあるとき
            {
                FTDI.FT_DEVICE_INFO_NODE[] ftList = new FTDI.FT_DEVICE_INFO_NODE[DevNum];
                ftDev.GetDeviceList(ftList);          // ** 接続デバイスの情報リストを取得 **

                int r;
                string SnoHead;
                for (r = 0; r != DevNum; r++)
                {
                    if (ftList[r].SerialNumber.Length != 8) continue;   // シリアル番号が8文字であること
                    SnoHead = ftList[r].SerialNumber.Substring(0, 2);   // シリアル番号の先頭2文字を取出す

                    // シリアル番号の確認

                    if (SnoHead == "DE")              // DACS-E350 のシリアル番号のとき
                    {
                        ftStatus = ftDev.OpenBySerialNumber(ftList[r].SerialNumber);  // ** シリアル番号でOPEN **
                        if (ftStatus != FTDI.FT_STATUS.FT_OK) continue;
                        ftStatus = ftDev.SetCharacters(0xd, true, 0, false);          // ** イベント文字(CR)を設定 **
                        ftStatus = ftDev.SetTimeouts(100, 100);                       // ** 送受信ﾀｲﾑｱｳﾄ設定 **
                        ftStatus = ftDev.SetBaudRate(115200);                         // ** 通信速度設定 **
                        ftStatus = ftDev.SetFlowControl(FTDI.FT_FLOW_CONTROL.FT_FLOW_XON_XOFF, 0, 0);  // ** 通信ﾌﾛｰ制御設定 **
                        if (ftStatus == FTDI.FT_STATUS.FT_OK) break;                  // 正常であればOPEN処理を終了する
                    }
                }
                if (r == DevNum)                      // 該当するデバイスがないとき
                {
                    DevNum = 0;
                    return;
                }
                else DevNum = 1;

                // DACS-E350の制御プログラム起動処理

                byte[] data = new byte[256];
                uint Writtten = 0;
                data = System.Text.Encoding.ASCII.GetBytes("root\r");
                ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** root 送信 (ログイン)**
                System.Threading.Thread.Sleep(200);

                data = System.Text.Encoding.ASCII.GetBytes("stty -echo\r");
                ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** stty -echo 送信 (エコーなしとする) **
                System.Threading.Thread.Sleep(200);

                data = System.Text.Encoding.ASCII.GetBytes("./dae350_l_std\r");
                ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** ./dae350_l_std 送信 (制御プログラムを起動) **
                System.Threading.Thread.Sleep(200);

                byte[] rxdata = new byte[1024];
                uint ReadAb = 0;
                uint ReadBy = 0;
                ftDev.GetRxBytesAvailable(ref ReadAb);                             // ** 受信データ数を取得 **
                if (ReadAb > 0) ftStatus = ftDev.Read(rxdata, ReadAb, ref ReadBy); // ** 受信データ(不要データ分)を読取り **
            }
        }

        // コマンド送信処理 (キーを押したとき)
        
        private void textBoxK_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (e.KeyCode == Keys.Return)                             // Enter キーを押したとき
            {
                recTimer.Stop();                                      // タイマー停止
                if (DevNum == 0) return;

                // キー入力した文字列をバイト配列にして、最後にCRコードを追加する

                byte[] data = System.Text.Encoding.ASCII.GetBytes(textBoxK.Text + "\r");
                uint Writtten = 0;
                ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** データ送信 **

                if (ftStatus == FTDI.FT_STATUS.FT_OK)
                {
                    textBoxT.Text = textBoxK.Text;                    // 送信データ表示
                    iTimeOut = 1;                                     // 受信タイムアウトカウント開始
                }
                else textBoxT.Text = "送信できません";

                textBoxR.Text = "";
                textBoxK.Text = "";
                recTimer.Start();                                     // タイマー開始
            }
            textBoxK.Focus();
        }

        // レスポンス受信処理 (タイマーイベント)
        
        private void OnTimerEvent(object source, ElapsedEventArgs e)
        {
            recTimer.Stop();                                          // タイマー停止

            uint ReadAb = 0;
            uint ReadBy = 0;
            uint r;
            byte[] rxdata = new byte[1024];

            ftDev.GetRxBytesAvailable(ref ReadAb);                    // ** 受信データ数を取得 **

            do
            {
                if (ReadAb >= 12)                                     // 受信データ数が12文字以上のとき
                {
                    r = ReadAb;
                    if (r > 12) r = 12;                               // 12文字を超えるときは12文字単位で読取る
                    ReadAb = ReadAb -r;
                    ftStatus = ftDev.Read(rxdata, r, ref ReadBy);     // ** 受信データ読取り **
                    if ((r == 12) && (rxdata[11] == 13))              // データ数が12文字で最後がCRのとき
                        textBoxR.Text = System.Text.Encoding.ASCII.GetString(rxdata); // 受信データ表示
                    else
                    {
                        if (ReadAb > 0)                               // 不正データのとき残留データをすべて読切る
                        {
                            if (ReadAb > 1024) ReadAb = 1024;
                            ftStatus = ftDev.Read(rxdata, ReadAb, ref ReadBy);
                            ReadAb = 0;
                        }
                    }
                    iTimeOut = 0;                                     // 受信タイムアウトカウントを停止する
                }
            } while (ReadAb >= 12);                                   // 12文字以上残っているときは受信を継続する

            if (iTimeOut > 0) iTimeOut = iTimeOut + 1;                // 受信タイムアウトカウンタ更新
            if (iTimeOut > 100)                                       // 受信タイムアウトのとき
            {
                textBoxR.Text = "受信タイムアウト";
                iTimeOut = 0;                                         // 受信タイムアウトカウンタ停止
            }
            textBoxK.Focus();

            recTimer.Start();                                          // タイマー開始
        }

        // 終了処理
        
        private void button3_Click(object sender, EventArgs e)
        {
            if (DevNum == 1)
            {
                recTimer.Stop();                 // タイマー停止
                ftDevCloseE350();                // 制御プログラム停止処理, DACS-E350をCLOSE
            }
            this.Close();                        // プログラム終了
        }

        // 制御プログラム停止処理, DACS-E350をCLOSE
        
        private void ftDevCloseE350()
        {
            // DACS-E350の制御プログラム停止処理

            byte[] data = new byte[256];
            uint Writtten = 0;
            data = System.Text.Encoding.ASCII.GetBytes("*\r");
            ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** アスタリスク 送信 (制御プログラム停止) **
            System.Threading.Thread.Sleep(200);

            data[0] = 26;
            ftStatus = ftDev.Write(data, 1, ref Writtten);            // ** ctr-Z 送信 (制御プログラム強制停止) **
            System.Threading.Thread.Sleep(200);

            data = System.Text.Encoding.ASCII.GetBytes("stty echo\r");
            ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** stty echo 送信 (エコーありに戻す) **
            System.Threading.Thread.Sleep(200);

            byte[] rxdata = new byte[1024];
            uint ReadAb = 0;
            uint ReadBy = 0;
            ftDev.GetRxBytesAvailable(ref ReadAb);                                 // ** 受信データ数を取得 **
            if (ReadAb > 0) ftStatus = ftDev.Read(rxdata, ReadAb, ref ReadBy);     // ** 受信データ(不要データ分)を読取り **

            // DACS-E350をCLOSE

            ftDev.Close();       // ** デバイスをCLOSE **
        }
    }
}
