/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EEPROM_4232H;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_4232H_Ctrl
extends FT_EE_Ctrl {
    private static final byte EEPROM_SIZE_LOCATION = 12;
    private static final String DEFAULT_PID = "6011";
    private static final int AL_DRIVE_CURRENT = 3;
    private static final int AH_DRIVE_CURRENT = 48;
    private static final int BL_DRIVE_CURRENT = 768;
    private static final int BH_DRIVE_CURRENT = 12288;
    private static final int AL_FAST_SLEW = 4;
    private static final int AL_SCHMITT_INPUT = 8;
    private static final int AH_FAST_SLEW = 64;
    private static final int AH_SCHMITT_INPUT = 128;
    private static final int BL_FAST_SLEW = 1024;
    private static final int BL_SCHMITT_INPUT = 2048;
    private static final int BH_FAST_SLEW = 16384;
    private static final int BH_SCHMITT_INPUT = 32768;
    private static final int TPRDRV = 24;
    private static final int AL_TXDEN = 4096;
    private static final int AH_TXDEN = 8192;
    private static final int BL_TXDEN = 16384;
    private static final int BH_TXDEN = 32768;

    FT_EE_4232H_Ctrl(FT_Device usbC) throws D2xxManager.D2xxException {
        super(usbC);
        this.getEepromSize((byte)12);
    }

    short programEeprom(FT_EEPROM ee) {
        int[] dataToWrite = new int[this.mEepromSize];
        if (ee.getClass() != FT_EEPROM_4232H.class) {
            return 1;
        }
        FT_EEPROM_4232H eeprom = (FT_EEPROM_4232H)ee;
        try {
            short driveC;
            short driveB;
            dataToWrite[0] = 0;
            if (eeprom.AL_LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 8;
            }
            if (eeprom.BL_LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 0x80;
            }
            if (eeprom.AH_LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 0x800;
            }
            if (eeprom.BH_LoadVCP) {
                dataToWrite[0] = dataToWrite[0] | 0x8000;
            }
            dataToWrite[1] = eeprom.VendorId;
            dataToWrite[2] = eeprom.ProductId;
            dataToWrite[3] = 2048;
            dataToWrite[4] = this.setUSBConfig(ee);
            dataToWrite[5] = this.setDeviceControl(ee);
            if (eeprom.AL_LoadRI_RS485) {
                dataToWrite[5] = (short)(dataToWrite[5] | 0x1000);
            }
            if (eeprom.AH_LoadRI_RS485) {
                dataToWrite[5] = (short)(dataToWrite[5] | 0x2000);
            }
            if (eeprom.BL_LoadRI_RS485) {
                dataToWrite[5] = (short)(dataToWrite[5] | 0x4000);
            }
            if (eeprom.BH_LoadRI_RS485) {
                dataToWrite[5] = (short)(dataToWrite[5] | 0x8000);
            }
            dataToWrite[6] = 0;
            byte driveA = eeprom.AL_DriveCurrent;
            if (driveA == -1) {
                driveA = 0;
            }
            dataToWrite[6] = dataToWrite[6] | driveA;
            if (eeprom.AL_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 4;
            }
            if (eeprom.AL_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 8;
            }
            if ((driveB = eeprom.AH_DriveCurrent) == -1) {
                driveB = 0;
            }
            driveB = (short)(driveB << 4);
            dataToWrite[6] = dataToWrite[6] | driveB;
            if (eeprom.AH_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 0x40;
            }
            if (eeprom.AH_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 0x80;
            }
            if ((driveC = eeprom.BL_DriveCurrent) == -1) {
                driveC = 0;
            }
            driveC = (short)(driveC << 8);
            dataToWrite[6] = dataToWrite[6] | driveC;
            if (eeprom.BL_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 0x400;
            }
            if (eeprom.BL_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 0x800;
            }
            short driveD = eeprom.BH_DriveCurrent;
            driveD = (short)(driveD << 12);
            dataToWrite[6] = dataToWrite[6] | driveD;
            if (eeprom.BH_SlowSlew) {
                dataToWrite[6] = dataToWrite[6] | 0x4000;
            }
            if (eeprom.BH_SchmittInput) {
                dataToWrite[6] = dataToWrite[6] | 0x8000;
            }
            boolean eeprom46 = false;
            int offset = 77;
            if (this.mEepromType == 70) {
                offset = 13;
                eeprom46 = true;
            }
            offset = this.setStringDescriptor(eeprom.Manufacturer, dataToWrite, offset, 7, eeprom46);
            offset = this.setStringDescriptor(eeprom.Product, dataToWrite, offset, 8, eeprom46);
            if (eeprom.SerNumEnable) {
                offset = this.setStringDescriptor(eeprom.SerialNumber, dataToWrite, offset, 9, eeprom46);
            }
            switch (eeprom.TPRDRV) {
                case 0: {
                    dataToWrite[11] = 0;
                    break;
                }
                case 1: {
                    dataToWrite[11] = 8;
                    break;
                }
                case 2: {
                    dataToWrite[11] = 16;
                    break;
                }
                case 3: {
                    dataToWrite[11] = 24;
                    break;
                }
                default: {
                    dataToWrite[11] = 0;
                }
            }
            dataToWrite[12] = this.mEepromType;
            if (dataToWrite[1] != 0 && dataToWrite[2] != 0) {
                boolean returnCode = false;
                returnCode = this.programEeprom(dataToWrite, this.mEepromSize);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    FT_EEPROM readEeprom() {
        FT_EEPROM_4232H eeprom = new FT_EEPROM_4232H();
        int[] data = new int[this.mEepromSize];
        if (this.mEepromBlank) {
            return eeprom;
        }
        try {
            short i = 0;
            while (i < this.mEepromSize) {
                data[i] = this.readWord(i);
                i = (short)(i + 1);
            }
            short data3x00 = (short)((data[0] & 8) >> 3);
            if (data3x00 == 1) {
                eeprom.AL_LoadVCP = true;
                eeprom.AL_LoadD2XX = false;
            } else {
                eeprom.AL_LoadVCP = false;
                eeprom.AL_LoadD2XX = true;
            }
            short data7x00 = (short)((data[0] & 0x80) >> 7);
            if (data7x00 == 1) {
                eeprom.BL_LoadVCP = true;
                eeprom.BL_LoadD2XX = false;
            } else {
                eeprom.BL_LoadVCP = false;
                eeprom.BL_LoadD2XX = true;
            }
            short data11x00 = (short)((data[0] & 0x800) >> 11);
            if (data11x00 == 1) {
                eeprom.AH_LoadVCP = true;
                eeprom.AH_LoadD2XX = false;
            } else {
                eeprom.AH_LoadVCP = false;
                eeprom.AH_LoadD2XX = true;
            }
            short data15x00 = (short)((data[0] & 0x8000) >> 15);
            if (data15x00 == 1) {
                eeprom.BH_LoadVCP = true;
                eeprom.BH_LoadD2XX = false;
            } else {
                eeprom.BH_LoadVCP = false;
                eeprom.BH_LoadD2XX = true;
            }
            eeprom.VendorId = (short)data[1];
            eeprom.ProductId = (short)data[2];
            this.getUSBConfig(eeprom, data[4]);
            this.getDeviceControl(eeprom, data[5]);
            if ((data[5] & 0x1000) == 4096) {
                eeprom.AL_LoadRI_RS485 = true;
            }
            if ((data[5] & 0x2000) == 8192) {
                eeprom.AH_LoadRI_RS485 = true;
            }
            if ((data[5] & 0x4000) == 16384) {
                eeprom.AH_LoadRI_RS485 = true;
            }
            if ((data[5] & 0x8000) == 32768) {
                eeprom.AH_LoadRI_RS485 = true;
            }
            short data01x06 = (short)(data[6] & 3);
            switch (data01x06) {
                case 0: {
                    eeprom.AL_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.AL_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.AL_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.AL_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data2x06 = (short)(data[6] & 4);
            eeprom.AL_SlowSlew = data2x06 == 4;
            short data3x06 = (short)(data[6] & 8);
            eeprom.AL_SchmittInput = data3x06 == 8;
            short data45x06 = (short)((data[6] & 0x30) >> 4);
            switch (data45x06) {
                case 0: {
                    eeprom.AH_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.AH_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.AH_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.AH_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data6x06 = (short)(data[6] & 0x40);
            eeprom.AH_SlowSlew = data6x06 == 64;
            short data7x06 = (short)(data[6] & 0x80);
            eeprom.AH_SchmittInput = data7x06 == 128;
            short data89X06 = (short)((data[6] & 0x300) >> 8);
            switch (data89X06) {
                case 0: {
                    eeprom.BL_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.BL_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.BL_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.BL_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data10x06 = (short)(data[6] & 0x400);
            eeprom.BL_SlowSlew = data10x06 == 1024;
            short data11x06 = (short)(data[6] & 0x800);
            eeprom.BL_SchmittInput = data11x06 == 2048;
            short data1213X06 = (short)((data[6] & 0x3000) >> 12);
            switch (data1213X06) {
                case 0: {
                    eeprom.BH_DriveCurrent = 0;
                    break;
                }
                case 1: {
                    eeprom.BH_DriveCurrent = 1;
                    break;
                }
                case 2: {
                    eeprom.BH_DriveCurrent = (byte)2;
                    break;
                }
                case 3: {
                    eeprom.BH_DriveCurrent = (byte)3;
                    break;
                }
            }
            short data14x06 = (short)(data[6] & 0x4000);
            eeprom.BH_SlowSlew = data14x06 == 16384;
            short data15x06 = (short)(data[6] & 0x8000);
            eeprom.BH_SchmittInput = data15x06 == 32768;
            short datax0B = (short)((data[11] & 0x18) >> 3);
            eeprom.TPRDRV = datax0B < 4 ? (int)datax0B : 0;
            int addr = data[7] & 0xFF;
            if (this.mEepromType == 70) {
                addr -= 128;
                eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, data);
                addr = data[8] & 0xFF;
                addr -= 128;
                eeprom.Product = this.getStringDescriptor(addr /= 2, data);
                addr = data[9] & 0xFF;
                addr -= 128;
                eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, data);
            } else {
                eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, data);
                addr = data[8] & 0xFF;
                eeprom.Product = this.getStringDescriptor(addr /= 2, data);
                addr = data[9] & 0xFF;
                eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, data);
            }
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    int getUserSize() {
        int data = this.readWord((short)9);
        int ptr = data & 0xFF;
        ptr /= 2;
        int length = (data & 0xFF00) >> 8;
        ptr += length / 2;
        return (this.mEepromSize - 1 - ++ptr) * 2;
    }

    int writeUserData(byte[] data) {
        int dataWrite = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1);
        int i = 0;
        while (i < data.length) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(s + 1);
            this.writeWord(s, (short)(dataWrite |= data[i] & 0xFF));
            i += 2;
        }
        return data.length;
    }

    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1);
        int i = 0;
        while (i < length) {
            short s = offset;
            offset = (short)(s + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
            i += 2;
        }
        return data;
    }
}

