import os
import ctypes
import time

# 関数 デバイスの初期化
#     引数   : デバイス番号(int型)
#     戻り値 : デバイスハンドル

def init_dacs26(devnum):
    os.system('sudo modprobe -r ftdi_sio')        # 仮想COMドライバを登録からはずす
                                                  #   ダイレクト版を動作可能とするため
    dll = ctypes.CDLL('/usr/local/lib/libftd2xx.so')
    hdl = ctypes.c_void_p()                       # デバイスハンドルの準備
    res = dll.FT_Open(ctypes.c_uint(devnum), ctypes.pointer(hdl))
    if res == 0:                                  # 正常にOPENできたとき
        res = dll.FT_SetTimeouts(hdl, 100, 100)   # タイムアウト時間(msec)を指定
    return hdl

# 関数 データ送信と応答受信
#     引数1  : デバイスハンドル
#     引数2  : 送信データ(int)  0～255    タイムアウト時間 5s
#     戻り値 : 受信データ(int)  0～255    タイムアウトのとき -1

def transfer_dacs26(hdl, wdata):
    dll = ctypes.cdll.LoadLibrary('/usr/local/lib/libftd2xx.so')

    # 残留受信データの確認と消去
    rqnum = ctypes.c_ulong(0)        # 受信済みデータ数の格納場所を準備
    trnum = ctypes.c_ulong(0)        # 送信済みデータ数の格納場所を準備
    event = ctypes.c_ulong(0)        # イベントの格納場所を準備
    dll.FT_GetStatus(hdl, ctypes.pointer(rqnum), ctypes.pointer(trnum), ctypes.pointer(event))
                                     # 残留受信データ数の確認
    if rqnum.value > 0:              # 残留データがあるとき
        if rqnum.value > 1024:
            n = 1024
        else:
            n = rqnum.value
        rdatabuf = ctypes.create_string_buffer(n+2)   # 残留受信データの格納場所を準備
        rdatanum = ctypes.c_ulong(0)                  # 残留受信データ数の格納場所を準備
        res = dll.FT_Read(hdl, ctypes.pointer(rdatabuf), rqnum, ctypes.pointer(rdatanum))
                                     # 残留受信データを読切る
    # データ送信
    if wdata >= 0:
        wbuff = ctypes.c_byte(wdata & 0xff) # 送信データをC言語の1バイトデータとする
        wrnum = ctypes.c_ulong(0)           # 送信したデータ数の格納場所を準備
        # 送信実行
        res = dll.FT_Write(hdl, ctypes.pointer(wbuff), 1, ctypes.pointer(wrnum))
    time.sleep(0.05)                 # 少し待つ(50ms)

    # データ受信
    rbuff = ctypes.c_ubyte(0)        # 受信したデータの格納場所を準備
    rdnum = ctypes.c_ulong(0)        # 受信したデータ数の格納場所を準備
    for cnt in range(50):
        # 受信実行(1バイトのデータを取得)
        res = dll.FT_Read(hdl, ctypes.pointer(rbuff), 1, ctypes.pointer(rdnum))
        if rdnum.value == 1:         # 受信データあり
            break
    if rdnum.value == 0:
        rdata = -1                   # タイムアウトのとき
    else:
        rdata = rbuff.value          # 受信したバイトデータをintに変換
    return rdata

# 関数 デバイスのclose
#     引数   : デバイスハンドル
#     戻り値 : 正常終了のとき0

def close_dacs26(hdl):
    dll = ctypes.cdll.LoadLibrary('/usr/local/lib/libftd2xx.so')
    res = dll.FT_Close(hdl)
    os.system('sudo modprobe ftdi_sio')         # 仮想COMドライバを登録する
                                                #   デフォルトにもどすため
    return res
