import ctypes
import time

# 関数 デバイスの初期化
#     引数   : デバイス番号(int型)
#     戻り値 : デバイスハンドル

def init_dacs(devnum):
    dll = ctypes.CDLL('FTD2xx.dll')
    hdl = ctypes.c_void_p()                       # デバイスハンドルの準備
    res = dll.FT_Open(ctypes.c_uint(devnum), ctypes.pointer(hdl))
    if res == 0:                                  # 正常にOPENできたとき
        res = dll.FT_SetChars(hdl, 0xd, 1, 0, 0)  # 区切り文字(0xd)を指定
        res = dll.FT_SetTimeouts(hdl, 100, 100)   # タイムアウト時間(msec)を指定

        # **** DACS-8200 ****
        #res = dll.FT_SetBaudRate(hdl, 1382400)
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-9600K ****
        #res = dll.FT_SetBaudRate(hdl, 230400);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 2, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-9600 ****
        #res = dll.FT_SetBaudRate(hdl, 38400);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-E350-STD ****
        #res = dll.FT_SetBaudRate(hdl, 115200);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0400, 0x11, 0x13)

    return hdl

# 関数 データ送信と応答受信
#     引数1  : デバイスハンドル
#     引数2  : 送信データ文字列  文字数が1以下のときは送信なし
#     引数3  : 最少受信データ数(int型)
#                -1    : 受信なし
#                 0    : 待ち時間100msの後に、受信データをすべて取得(最大1000byte)
#                 1以上: 指定文字数分のデータを受信
#                        指定文字数のデータがすでにあれば、待ち時間なし
#                        指定文字数を受信するまで、待ち時間10msで最大50回くり返し
#     戻り値 : 受信データ文字列

def transfer_dacs(hdl, wdata, rnum):
    dll = ctypes.CDLL('FTD2xx.dll')

    # **** データ送信 ****

    if len(wdata) > 1:
        # 送信する文字列をASCII文字列に変換
        wdatabuf = ctypes.create_string_buffer(wdata.encode('ascii'))
        wrnum = ctypes.c_ulong(0)    # 送信した文字数の格納場所を準備
        # 送信実行
        res = dll.FT_Write(hdl, ctypes.pointer(wdatabuf), ctypes.c_ulong(len(wdatabuf)-1), ctypes.pointer(wrnum))

    # **** データ受信 ****

    rdata = ''                       # 受信データ文字列を空にする
    if rnum < 0:
        return rdata                 # 送信のみのときは終了

    rqnum = ctypes.c_ulong(0)        # 受信済み文字数の格納場所を準備
    trnum = ctypes.c_ulong(0)
    event = ctypes.c_ulong(0)

    for cnt in range(50):            # 受信待ちループ
        if rnum == 0:                # 受信データ数の指定なしのときのみ、
            time.sleep(0.1)          #     受信データ数の確認前に十分長い時間待ちをする
        # 受信データ数の確認
        res = dll.FT_GetStatus(hdl, ctypes.pointer(rqnum), ctypes.pointer(trnum), ctypes.pointer(event))

        # 受信データ数が指定数と同じか超えたとき
        if rqnum.value >= rnum:
            if rqnum.value > 0:
                # 受信データを格納するASCII文字列領域を準備
                rdatabuf = ctypes.create_string_buffer((' '*1024).encode('ascii'))
                rdnum = ctypes.c_ulong(0)       # 受信した文字数の格納場所を準備

                # 受信データを取得
                if rnum > 0:
                    rqnum.value = rnum          # 受信文字数指定のとき
                if rqnum.value > 1024:
                    rqnum.value = 1000          # 最大データ数をバッファサイズに制限
                res = dll.FT_Read(hdl, ctypes.pointer(rdatabuf), rqnum, ctypes.pointer(rdnum))

                # 受信データ領域から受信データ数分のデータを抽出し、cp932コード文字列に変換
                if rdnum.value != 0:
                    rdata = ((rdatabuf.value)[0:(rdnum.value)]).decode('cp932')
            break                    # 受信待ちループ終了
        time.sleep(0.01)             # 短い待ち時間
    return rdata

# 関数 デバイスのclose
#     引数   : デバイスハンドル
#     戻り値 : 正常終了のとき0

def close_dacs(hdl):
    dll = ctypes.CDLL('FTD2xx.dll')
    return dll.FT_Close(hdl)
