/*****************************************************************************
 *****************************************************************************


 DACS-1700K-VCN  JE^/gv eXgvO  D17KDIVCN.CPP

                                          _bNXZ  2019/02/06

******************************************************************************
*****************************************************************************/

// P   VC2015p                                            2020/06/11

#include <windows.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include "resource.h"
                         // *************************************************
#include "Ftd2xx.h"      // *      ޲ڸĔײޗp̧ͯقǉ           *
                         // *************************************************
#define   ID_TIMER   1                           // ϰID

int     WINAPI   WinMain        (HINSTANCE ,HINSTANCE ,LPSTR ,int );
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

int              DRM_Open       (void);          // ޲ڸĔłDACS-1700Kopen
int              hextobin(int, char *);
void             Crt_GetDC      (void);
void             Crt_ReleaseDC  (void);

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int    Strh    = 16;                             // 
int    Strw    =  8;                             // 
char  *Strfont = "lr SVbN";                // (޼)"

char   kinbuf[128];                              // ޯ̧
int    kincnt  = 0;                              // ͐
char   cntdatabuf[10];                           // Mްۑޯ̧
int    ID_number = 99;                           // IDԍ
int    freqcountno[8];                           // gvްۑ

FT_HANDLE   ftHandle;
FT_STATUS   ftStatus;

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);          // ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  HWND   hwnd;                                   // 쐬Ҳݳ޳
  int    r;

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd = CreateWindow  (cName,                   // ޳׽       (RegisterClassœo^O)
                        "DACS-1700K-VCN JE^/gv eXgvO", // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        880,                     //    ̏l     (CW_USEDEFAULT)
                        610,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd = hwnd;                                   // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);
  r = DRM_Open();                                // ޲OPENB޲ݒ
  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  if(r == 0){
      TextOut(hDc, 10, 20, " ڑȂ ", 10);
  }
  else{
      TextOut(hDc,10,60,"  >>                                  ",44);
      TextOut(hDc,100,60,"_",1);                 // ͗\
  }
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
  SetTimer(hwnd, ID_TIMER, 50, NULL);            // 50msecϰݒ
  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  PAINTSTRUCT ps;
  char        buf[256], rxbuf[256], txbuf[256];
  int         r, l, ydisp, repcnt, cno;
  double      freqdata;
  DWORD       WriteNum, TransNum;
  DWORD       ReadNum, RecNum, EventDword;

  switch(message)
  {
    case WM_COMMAND:                          // *** ޑ ***
           switch(LOWORD(wParam))
           {
             case ID_EXIT : DestroyWindow(hwnd); break;
                                              // ۸яI
             default      : return(DefWindowProc(hwnd, message, wParam, lParam));
                             break;
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***
          KillTimer(hwnd, ID_TIMER);             // ϰI
          switch(wParam){
               case 0x1b:                        // ESC ̂Ƃر
                   kincnt = 0;
                   break;
               case 0x08:                        // BS ̂Ƃ-1
                   kincnt = kincnt - 1;
                   break;
               default :                         // ްi[
                   kinbuf[kincnt] = wParam;
                   kincnt = kincnt + 1;
                   break;
           }
           if(kincnt < 0) kincnt = 0;            // ͐𐧌
           if(kincnt > 32) kincnt = 32;
           kinbuf[kincnt] = '_';                 // وʒu\pLǉ
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           TextOut(hDc,10,60,"  >>                                  ",44);
           TextOut(hDc,100,60,kinbuf,kincnt+1);  // ̓f[^\

           if(wParam == 0xd){                    // Enter ̂Ƃ
               if(kincnt !=0){
                   TextOut(hDc,10,60,"  >>                                  ",44);
                   WriteNum = kincnt;
                   l = sprintf_s(buf,128,"M    >>                                  "); // \̈ر
                   TextOut(hDc,10,90,buf,l);
                   l = sprintf_s(buf,128,"M    >>                                  ");
                   TextOut(hDc,10,160,buf,l);
                   r = -1;
                   if((kinbuf[1] > 0x2f) && (kinbuf[1] < 0x3a)) r = kinbuf[1] - 0x30;
                   if((kinbuf[1] > 0x40) && (kinbuf[1] < 0x47)) r = kinbuf[1] - 0x41 + 10;
                   r = r & 3;                // ͂ɂw肵ĂIDԍ擾
                   if((ID_number == r) || (ID_number == 16)){
                                             // IDmς݂?
                       TransNum = 0;

                       ftStatus = FT_Write(ftHandle,kinbuf,WriteNum,&TransNum);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Write                 *
                         // *  kinbufɂްWriteNum ɂĎwM *
                         // *  TransNum ɂ͎ۂɑM߂        *
                         // *************************************************

                       if(TransNum > 0){
                           kincnt = TransNum;
                           TextOut(hDc,100,90,kinbuf,kincnt);  // Mf[^\
                       }
                   }
               }
               kincnt = 0;
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           SetTimer(hwnd, ID_TIMER, 50, NULL);   // 50msecϰݒ
           break;

    case WM_TIMER:                           // *** ݒ莞 ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           // *** ްM (9擾66񂭂Ԃ) ***
           //     ɂԂĂꍇ́A9Ȃް64M
           //     ͂ɂްMꍇ́AP]ɎM
           //     ɗ]1́AްM̓͂ꂽꍇɁAMޯ̧ɂްǂݐ؂邽

           Crt_GetDC();                          // DC̏ݒ (,,׼ = )

           for(repcnt = 0;repcnt != 66;repcnt++){
               ReadNum = 0;

               FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_GetStatus             *
                         // *      ReadNum ɎMςް擾           *
                         // *************************************************

               if(ReadNum > 0){                  // Mςް 1 ȏ̂Ƃ

                   if(ReadNum > 9) ReadNum = 9;
                   ftStatus = FT_Read(ftHandle,rxbuf,ReadNum,&RecNum);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Read                  *
                         // *  bufɤReadNum ɂĎw肵ްǎ *
                         // *  RecNum ɂ͎ۂɎM߂          *
                         // *************************************************
                   r = RecNum;
                   if((rxbuf[0] == 'N') && (r == 9)){      // *** lްMƂ̏ ***
                       if(((rxbuf[2] >= '0') && (rxbuf[2] <= '9')) || ((rxbuf[2] >= 'A') && (rxbuf[2] <= 'F'))){
                           if(rxbuf[2] > '9') rxbuf[2] = rxbuf[2] - 7;
                           cno = (int)((rxbuf[2]-0x30)/2);              // ԍ擾
                           if(cno > 3) cno = cno + 4;                   // ΰޒl̔ԍϊ
                           if(rxbuf[1] > 0x37) cno = cno + 4;           // ٰ2̶
                           ydisp = 240+15*cno;                          // \ʒu Y
                           if(cno > 7) ydisp = ydisp + 30;
                           if(rxbuf[2] & 1){
                               TextOut(hDc,150,ydisp,&rxbuf[4],4);             // High word l\
                               for(r = 0; r != 4; r++) cntdatabuf[r] = rxbuf[4+r]; // Mlۑ
                               r = hextobin(8, &cntdatabuf[0]);                // 16i𐮐lɕϊ
                               l = sprintf_s(buf,128," %12d ",r);
                               TextOut(hDc,240,ydisp,buf,l);                   // l10i\
                           }
                           else{
                               l = sprintf_s(buf,128," %1d >>               ",cno);
                               TextOut(hDc,10,ydisp,buf,l);
                               TextOut(hDc,185,ydisp,&rxbuf[4],4);             // low word  l\
                               for(r = 0; r != 4; r++) cntdatabuf[4+r] = rxbuf[4+r]; // Mlۑ
                           }
                       }
                   }
                   else{
                       if((rxbuf[0] == 'n') && (r == 9)){      // *** glްMƂ̏ ***
                           if(((rxbuf[2] >= '0') && (rxbuf[2] <= '9')) || ((rxbuf[2] >= 'A') && (rxbuf[2] <= 'F'))){
                               if(rxbuf[2] > '9') rxbuf[2] = rxbuf[2] - 7;
                               cno = (int)((rxbuf[2]-0x30)/2);          // ԍ擾
                               if(cno > 3) cno = cno + 4;               // ٽԊul̔ԍϊ
                               if(rxbuf[1] > 0x37) cno = cno + 4;       // ٰ2̶
                               ydisp = 240+15*cno;                      // \ʒu Y
                               if(cno > 7) ydisp = ydisp + 30;
                               if(rxbuf[2] & 1){
                                   TextOut(hDc,420,ydisp,&rxbuf[4],4);         // High word l\
                                   for(r = 0; r != 4; r++) cntdatabuf[r] = rxbuf[4+r]; // Mlۑ
                                   r = hextobin(8, &cntdatabuf[0]);            // 16i𐮐lɕϊ
                                   l = sprintf_s(buf,128," %12d ",r);
                                   TextOut(hDc,510,ydisp,buf,l);               // gv񐔂܂ٽԊu10i\
                                   if(cno > 7){                                // ٽԊuMƂ
									   if(r != 0) freqdata = (double)freqcountno[cno-8]/((double)r)*25000000;
									   else       freqdata = 0;
                                       l = sprintf_s(buf,128," %17.7f Hz",freqdata);
                                       for(r = 17; r != 10; r--){              // ̏
                                           if((buf[r-8] != 0x20) && (buf[r-8] != '-')) buf[r] = 0x20;
                                       }
                                       TextOut(hDc,650,ydisp,buf,l);           // g\
                                   }
                                   else freqcountno[cno] = r;
                               }
                               else{
                                   TextOut(hDc,455,ydisp,&rxbuf[4],4);         // low word  l\
                                   for(r = 0; r != 4; r++) cntdatabuf[4+r] = rxbuf[4+r]; // Mlۑ
                               }
                           }
                       }
                       else{                               // *** lްȊOMƂ̏ ***
                           l = sprintf_s(buf,128,"M    >>                                  ");
                           TextOut(hDc,10,160,buf,l);
                           TextOut(hDc,100,160,rxbuf,r);   // Mf[^\
                       }
                   }
                   r = -1;
                   if((rxbuf[1] > 0x2f) && (rxbuf[1] < 0x3a)) r = rxbuf[1] - 0x30;
                   if((rxbuf[1] > 0x40) && (rxbuf[1] < 0x47)) r = rxbuf[1] - 0x41 + 10;
                   if(r >= 0) ID_number = r & 3;           // MްIDԍ擾
                   if(repcnt == 0){                            // \
                       l = sprintf_s(buf,128,"JEgl");
                       TextOut(hDc,148,220,buf,l);
                       l = sprintf_s(buf,128,"z[hl");
                       TextOut(hDc,148,370,buf,l);
                       l = sprintf_s(buf,128,"v(N)");
                       TextOut(hDc,420,220,buf,l);
                       l = sprintf_s(buf,128,"vl(P)");
                       TextOut(hDc,420,370,buf,l);
                       l = sprintf_s(buf,128,"g(f)");
                       TextOut(hDc,720,370,buf,l);
                   }
               }
           }
           Crt_ReleaseDC();                        // DC̏Iݒ (,,׼ = )

           // *** Mނׯڼ޽(high/low word) M ***
           // *** mނgv񐔕ٽԊu(high/low word) M ***

           txbuf[0] = 'M';                       // M޺޾
           txbuf[3] = 0xd;                       // CR޾
           WriteNum = 4;                         // ް

           if(ID_number < 16){                   // IDԍmH
               _itoa_s(ID_number,&txbuf[1],2,16); // IDԍ
               for(repcnt = 0; repcnt != 64; repcnt++){
                   if(repcnt == 32){
                       txbuf[0] = 'm';           // m޺޾
                       if(txbuf[1] > 0x39) txbuf[1] = txbuf[1] - 15;
                       else                txbuf[1] = txbuf[1] - 8;
                   }
                   if((repcnt == 16) || (repcnt == 48)){  // ٰ2ɕύX
                       txbuf[1] = txbuf[1] + 8;
                       if(txbuf[1] > 0x39) txbuf[1] = txbuf[1] + 7;
                   }
                   r = repcnt & 0xf;
                   if(r > 9) r = r + 7;
                   txbuf[2] = (char)(r) + 0x30;     // (ԍ)*2 + (word 敪)
                   TransNum = 0;
                   ftStatus = FT_Write(ftHandle,txbuf,WriteNum,&TransNum);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Write                 *
                         // *  kinbufɂްWriteNum ɂĎwM *
                         // *  TransNum ɂ͎ۂɑM߂        *
                         // *************************************************
               }
           }
           SetTimer(hwnd, ID_TIMER, 50, NULL);   // 50msecϰݒ
           break;

    case WM_PAINT:                           // IME ON  OFF łĂ΂
           hDc = BeginPaint(hwnd, &ps);          // WNDCLASS  hbrBackground ŕ`悳
                                                 // (InitApplication֐Őݒς)
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           EndPaint(hwnd, &ps);
           break;

    case WM_DESTROY:                         // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           ftStatus = FT_Close(ftHandle);        // ޲CLOSE
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Close                 *
                         // *      ޲CLOSE                            *
                         // *************************************************
           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           return(DefWindowProc(hwnd, message, wParam, lParam));
           break;
  }

  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : int DRM_Open(void)
   Ұ : Ȃ
      : ڑĂDACS-1700KJ
   ߂l : OPENłƂ : 1  OPENłȂƂ : 0
******************************************************************************/

int DRM_Open(void)
{
  int         r;
  DWORD       devIndex, devs;
  char        serbuf[16];

  for(r = 0; r < 20000; r++){
      devs = 0;
      ftStatus = FT_ListDevices(&devs,NULL,FT_LIST_NUMBER_ONLY);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_ListDevices           *
                         // *      devs ɐڑ޲擾                *
                         // *************************************************
      if(devs != 0) break;
  }
  if(devs < 1) return(0);       // ڑ޲0̂Ƃ͏I
  else{
      ID_number = 99;           // ðقIDԍƂďlݒ
      devIndex = 0;
      for(r = 0; r < 20000; r++){
          ftStatus = FT_ListDevices((PVOID)devIndex,serbuf,
                                 FT_LIST_BY_INDEX|FT_OPEN_BY_SERIAL_NUMBER);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_ListDevices           *
                         // *      serbuf ޲̼رٔԍ擾          *
                         // *************************************************
          if(ftStatus == FT_OK) break;
      }
      if(ftStatus == FT_OK){
          ftStatus = FT_OpenEx(serbuf,FT_OPEN_BY_SERIAL_NUMBER,&ftHandle);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_OpenEx                *
                         // *      رٔԍ޲OPEN           *
                         // *************************************************
          if(ftStatus == FT_OK){
              ftStatus = FT_SetChars(ftHandle,0x0d,1,0x0,0);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_SetChars              *
                         // *      ĕ(CR)ݒ                    *
                         // *************************************************
              ftStatus = FT_SetTimeouts(ftHandle,100,100);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_SetTimeouts           *
                         // *      MѱĐݒ                         *
                         // *************************************************
              ID_number = 16;   // IDԍɐڑ׸ސݒ
          }
      }
  }
  return(1);
}

/******************************************************************************
   ֐   : int hextobin(int num,char *buf)
   Ұ : num HEXް
            *str HEXް  
      : HEXintɕϊ
   ߂l : ϊbinaryް   ُ̂Ƃ-1
******************************************************************************/

int hextobin(int num, char *buf)
{
    char  datatmp;
    int   cnt, tmp;
    int   ret = 0;

    if(num < 1) return(-1);
    for(cnt = 0; cnt != num; cnt++){
        datatmp = buf[cnt];
        tmp = -1;
        if((datatmp > 0x2f) && (datatmp < 0x3a)) tmp = datatmp - 0x30;
        if((datatmp > 0x40) && (datatmp < 0x47)) tmp = datatmp - 0x41 + 10;
        if(tmp == -1) return(-1);
        else          ret = ret*16 + tmp; 
    }
    return(ret);
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}

/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
