﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FTD2XX_NET;       // 参照設定に FTD2XX_NET.dll を登録し、この1行を追加する

namespace DacsMuTxRx
{
    public partial class Form1 : Form
    {
        uint DevNum = 0;                                 // 接続デバイス数
        char[] IDnum = new char[4] {'*','*','*','*'};    // デバイスID番号テーブル
        char IDnumSend;                                  // 最後に送信したデータのID番号 
        const uint DevMax = 4;                           // 本プログラムでは最大有効デバイス数を4とする
        FTD2XX_NET.FTDI[] ftDev = new FTDI[4] { new FTDI(), new FTDI(), new FTDI(), new FTDI() };
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

        public Form1()
        {
            InitializeComponent();
            this.Text = "DACS マルチデバイス送受信サンプル";

            ftDevOpenDacs();        // DACS製品を選択してOPEN

            label2.Text = "接続";
            if (DevNum == 0) textBoxT.Text = "デバイス接続なし";
            else textBoxT.Text = DevNum.ToString() + "個のデバイスを接続";

            IDnumDisp();            // ID番号テーブルを表示
            textBoxK.Focus();
        }

        // 送信ボタンを押したとき

        private void button1_Click(object sender, EventArgs e)
        {
            if (DevNum == 0) return;

            string TxData;
            TxData = textBoxK.Text;

            textBoxK.Text = "";
            textBoxR.Text = "";
            label2.Text = "送信";
             
            if (ftDevWriteDacs(TxData) == 0) textBoxT.Text = "送信できません"; // データ送信
            else
            {
                textBoxT.Text = TxData;       // 送信データを表示

                string RxData;
                RxData = ftDevReadDacs();     // データ受信

                if (RxData == "") textBoxR.Text = "受信できません";
                else textBoxR.Text = RxData;  // 受信データを表示
            }
            IDnumDisp();            // ID番号テーブルを表示
            textBoxK.Focus();
        }

        // 再接続ボタンを押したとき

        private void button2_Click(object sender, EventArgs e)
        {
            uint r;
            for (r = 0; r != DevNum; r++) ftDev[r].Close();    // ** デバイスをCLOSE **

            textBoxK.Text = "";
            textBoxR.Text = "";
            textBoxT.Text = "";

            ftDevOpenDacs();         // 再度デバイスOPEN

            label2.Text = "接続";
            if (DevNum == 0) textBoxT.Text = "デバイス接続なし";
            else textBoxT.Text = DevNum.ToString() + "個のデバイスを接続";

            IDnumDisp();            // ID番号テーブルを表示
            textBoxK.Focus();
        }

        // 終了ボタンを押したとき

        private void button3_Click(object sender, EventArgs e)   
        {
            uint r;
            for (r = 0; r != DevNum; r++) ftDev[r].Close();    // ** デバイスをCLOSE **
            this.Close();            // プログラム終了
        }

        // キー入力ボックスに最初の文字入力があったとき、送信/受信データボックスの表示を消す

        private void textBoxK_TextChanged(object sender, EventArgs e)
        {
            if ((textBoxK.Text.Length == 1) && (DevNum != 0))
            {
                textBoxR.Text = "";
                textBoxT.Text = "";
            }
        }

        // ID番号テーブルを表示

        private void IDnumDisp()
        {
            uint r;
            label4.Text = "接続デバイス";
            for (r = 0; r != DevNum; r++) label4.Text += " ID=" + IDnum[r].ToString();
        }


        ////////////////////////
        // DACSデバイスをOPEN //
        ////////////////////////

        private void ftDevOpenDacs()
        {
            uint r;
            for (r = 0; r != DevMax; r++) IDnum[r] = '*'; // デバイスID番号テーブルを初期設定

            ftDev[0].GetNumberOfDevices(ref DevNum);     // ** 接続デバイス数を取得 **

            if (DevNum != 0)                             // 接続デバイスがあるとき
            {
                FTDI.FT_DEVICE_INFO_NODE[] ftList = new FTDI.FT_DEVICE_INFO_NODE[DevNum];
                ftDev[0].GetDeviceList(ftList);          // ** 接続デバイスの情報リストを取得 **

                string SnoHead;
                if (DevNum > 10) DevNum = 10;            // 検索デバイス数を制限
                uint s = 0;
                for (r = 0; r != DevNum; r++)
                {
                    if (ftList[r].SerialNumber.Length != 8) continue;   // シリアル番号が8文字であること
                    SnoHead = ftList[r].SerialNumber.Substring(0, 1);   // シリアル番号の先頭1文字を取出す

                    // シリアル番号の確認

                    if (SnoHead == "D")
                    {
                        ftStatus = ftDev[s].OpenBySerialNumber(ftList[r].SerialNumber);  // ** シリアル番号でOPEN **
                        if (ftStatus != FTDI.FT_STATUS.FT_OK) continue;
                        ftStatus = ftDev[s].SetCharacters(0xd, true, 0, false);          // ** イベント文字(CR)を設定 **
                        ftStatus = ftDev[s].SetTimeouts(100, 100);                       // ** 送受信ﾀｲﾑｱｳﾄ設定 **
                        if (ftStatus == FTDI.FT_STATUS.FT_OK)
                        {
                            s++;                         // 有効デバイス数を更新
                            if(s >= DevMax) break;       // 最大有効デバイス数を超えたときはOPEN処理を終了する
                        }
                    }
                }
                DevNum = s;                              // 有効デバイス数をセット
           }
        }

        ////////////////////////
        // データ送信         //
        ////////////////////////
        
        private int ftDevWriteDacs(string TxData)       // 戻り値 正常にデータ送信ができたデバイス数
        {                                               // ID番号が未確定のデバイスがあれば複数デバイスに送信
            int r = 0;
            if (TxData.Length < 2) return r;

            IDnumSend = TxData[1];                      // 送信データのID番号を保存

            // 送信文字列をバイト配列にして、最後にCRコードを追加する
            byte[] data = System.Text.Encoding.ASCII.GetBytes(TxData + "\r");

            uint s;
            for (s = 0; s != DevNum; s++)
            {
                if ((IDnum[s] == IDnumSend) || (IDnum[s] == '*'))
                {
                    // 送信文字列のIDとデバイスIDテーブルの番号が一致するか
                    // または未確定デバイスの場合にデータ送信を実行する

                    uint Writtten = 0;
                    ftStatus = ftDev[s].Write(data, data.Length, ref Writtten);  // ** データ送信 **
                    if (ftStatus == FTDI.FT_STATUS.FT_OK) r++;                   // 送信済みデバイス数を更新
                    if (IDnum[s] == IDnumSend) break;

                    // 送信文字列のIDとデバイスIDテーブルの番号が一致すれば、以後の処理はしない
                    // 全デバイスのID確定後は、1デバイスのみ送信対象となる
                }
            }
            return r;
        }

        ////////////////////////
        // データ受信         //
        ////////////////////////

        private string ftDevReadDacs()                   // 受信した文字列を戻す
        {
            uint s;
            uint t;
            uint ReadAb = 0;                             // 受信可能データ数
            uint ReadBy = 0;                             // 実際に取得した受信データ数
            const int iTimeOut = 10;                     // タイムアウト 10*10ms = 100ms
            byte[] data = new byte[256];                 // 受信データバッフア
            string RxData = "";

            for (s = 0; s != DevNum; s++)
            {
                if ((IDnum[s] == IDnumSend) || (IDnum[s] == '*'))
                {
                    // 送信した文字列のIDとデバイスIDテーブルの番号が一致するか
                    // または未確定デバイスの場合にデータ受信を実行する

                    for (t = 0; t < iTimeOut; t++)       // データを受信するか、タイムアウトになるまで続ける
                    {
                        ftDev[s].GetRxBytesAvailable(ref ReadAb);               // ** 受信可能データ数を取得 **

                        if ((ReadAb >= 9) || (ReadAb > 0) && (t > iTimeOut / 2))
                        {
                            // 受信データ数が9文字以上(正常)か、時間が経過しても1文字以上で8文字以下(異常)のとき

                            ftStatus = ftDev[s].Read(data, ReadAb, ref ReadBy); // ** 受信データ読取り **
                            if ((ftStatus == FTDI.FT_STATUS.FT_OK) && (ReadBy >= 9))
                            {
                                if (data[1] == (byte)IDnumSend)
                                {
                                    // バイト配列を文字列に変換する
                                    RxData = System.Text.Encoding.ASCII.GetString(data);

                                    // デバイスIDテーブルに受信データのID番号を登録
                                    if (IDnum[s] == '*') IDnum[s] = RxData[1];
                                }
                            }
                            break;
                        }
                        System.Threading.Thread.Sleep(10);   // 受信可能データがない場合 10ms待つ
                    }
                    if (IDnum[s] == IDnumSend) break;

                    // 受信文字列のIDとデバイスIDテーブルの番号が一致すれば、以後の処理はしない
                    // 全デバイスのID確定後は、1デバイスのみ受信対象となる
                }
            }
            return RxData;
        }
    }
}
