# DACS-2500KB デジタル入出力 サンプルプログラム

# Windows11/10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# Ddio_sample.py、Ddio.py、FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# Ddio_sample.py を起動すると
# キー入力待ちになります。

# 以下のキー入力後、enterにて指示データを送信
#     DW,y--y
#        y--y デジタル出力(16進数6桁 bit23～0)
#        デジタル入力(16進数6桁 bit23～0)を受信して表示
#     DR デジタル出力は変化なし
#        デジタル入力(16進数6桁 bit23～0)を受信して表示
# その他の操作詳細は、Ddio.py 関数の注釈をご覧ください。

# -(マイナス) enter にてプログラム終了

import Ddio
import time

# デバイスをOPEN、デジタル入出力ボードを確認
ret = Ddio.Ddio_init(9)
if ret[0] == 'OK':
    handle = ret[1]     # デバイスハンドルをセット
    print('OK')
else:
    print('no device')
    time.sleep(3)
    exit()

# キー入力とコマンド送信を繰返す
while True:
    kydatabuf = input()
    # マイナスキー入力のときは終了
    if kydatabuf == '-':
        break
    # コマンド送信
    readdata = Ddio.Ddio_write(handle, kydatabuf)
    # 応答結果を表示
    if len(readdata) != 0:
        print(readdata)
    else:
        print('data error')
    continue

# デバイスをCLOSE
Ddio.Ddio_close(handle)
