/*****************************************************************************
 *****************************************************************************


 DACS-2600 (USB-DIO) ʐMý۸ <_CNghCo> D16DIDR.CPP

                                          _bNXZ  2003/07/03

******************************************************************************
*****************************************************************************/

// P   ^CAEg^C}[ǉ                            2004/05/27
// Q   OPEN                                        2007/01/08
// R   VC2008p                                            2015/04/18

#include <windows.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include "resource.h"
                         // *************************************************
#include "Ftd2xx.h"      // *      ޲ڸĔײޗp̧ͯقǉ           *
                         // *************************************************
#define   ID_TIMER   1                           // ϰID

int     WINAPI   WinMain        (HINSTANCE ,HINSTANCE ,LPSTR ,int );
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

void             Crt_GetDC      (void);
void             Crt_ReleaseDC  (void);
int              hextobin       (int, char *);

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int    Strh    = 16;                             // 
int    Strw    =  8;                             // 
char  *Strfont = "lr SVbN";                // (޼)"

char        keybuf[16];                          // ޯ̧
char        senbuf[16];                          // Mްޯ̧
int         keyinnum = 0;                        // ͐
FT_HANDLE   ftHandle[4];
FT_STATUS   ftStatus;
DWORD       numDevs;
int         RxTimecount;                         // MѱĶ

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);          // ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  HWND   hwnd;                                   // 쐬Ҳݳ޳

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd = CreateWindow  (cName,                   // ޳׽       (RegisterClassœo^O)
                        "c`br|QUOOʐMeXg", // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        500,                     //    ̏l     (CW_USEDEFAULT)
                        400,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd = hwnd;                                   // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);
  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  PAINTSTRUCT ps;
  char        buf[256];
  int         r, s, devcnt, devlast;
  DWORD       WriteNum, TransNum;
  DWORD       ReadNum, RecNum, EventDword;
  DWORD       devIndex;

  switch(message)
  {
    case WM_COMMAND:                          // *** ޑ ***
           switch(LOWORD(wParam))
           {
             case ID_EXIT : DestroyWindow(hwnd); break;
                                              // ۸яI
             default      : return(DefWindowProc(hwnd, message, wParam, lParam));
                             break;
           }
           break;

    case WM_CREATE:                           // *** ޲OPEN ***
           numDevs = 0;
           r = 0;
           do{

               ftStatus = FT_ListDevices(&numDevs,NULL,FT_LIST_NUMBER_ONLY);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_ListDevices           *
                         // *      numDevs  ɐڑ޲擾            *
                         // *************************************************

               r = r + 1;
               if(r > 20000) break;
           }while(numDevs == 0);
           if(numDevs > 4) numDevs = 4;          // ڑ޲ő吔4ɐ
           if(numDevs < 1) break;                // ڑ޲0̂Ƃ͏I

           devlast = numDevs;
           for(devcnt = 0;devcnt != devlast;devcnt++){
               devIndex = (DWORD)devcnt;
               r = 0;
               do{

                   ftStatus = FT_ListDevices((PVOID)devIndex,buf,
                                          FT_LIST_BY_INDEX|FT_OPEN_BY_SERIAL_NUMBER);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_ListDevices           *
                         // *      buf ޲̼رٔԍ擾             *
                         // *************************************************

                   r = r + 1;
                   if(r > 5000) break;
               }while(ftStatus != FT_OK);

               if(ftStatus == FT_OK){

                   ftStatus = FT_OpenEx(buf,
                                        FT_OPEN_BY_SERIAL_NUMBER,&ftHandle[devcnt]);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_OpenEx                *
                         // *      رٔԍ޲OPEN           *
                         // *************************************************

                   ftStatus = FT_SetTimeouts(ftHandle[devcnt],100,100);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_SetTimeouts           *
                         // *      MѱĐݒ                         *
                         // *************************************************
               }
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***
           if(keyinnum == 0){
               keybuf[0] = (char)wParam;                // 16ȉʌ擾
               keyinnum = 1;
               break;
           }
           keybuf[1] = (char)wParam;                    // 16ỉʌ擾
           keyinnum = 0;
           senbuf[0] = (char)hextobin(2, keybuf);       // ͕޲ް(1byte)ɕϊ
           WriteNum = 1;                                // Mް1Ƃ
           devlast = numDevs;
           Crt_GetDC();                                 // DC̏ݒ (,,׼ = )
           for(devcnt = 0;devcnt != devlast;devcnt++){  // ޲̌JԂ
               sprintf_s(buf,128,"M %1d  >>     ",devcnt);   // \̈ر
               TextOut(hDc,10,90+15*devcnt,buf,strlen(buf));
               sprintf_s(buf,128,"M %1d  >>     ",devcnt);
               TextOut(hDc,10,160+15*devcnt,buf,strlen(buf));
               TransNum = 0;
               ftStatus = FT_Write(ftHandle[devcnt],senbuf,WriteNum,&TransNum);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Write                 *
                         // *  kinbufɂްWriteNum ɂĎwM *
                         // *  TransNum ɂ͎ۂɑM߂        *
                         // *************************************************

               if(TransNum > 0){
                   s = (int)senbuf[0] & 0xff;
                   sprintf_s(buf,128,"%02x",s);
                   TextOut(hDc,100,90+15*devcnt,buf,2);  // Mf[^\
                   SetTimer(hwnd, ID_TIMER, 20, NULL);   // 20msecϰݒ
                   RxTimecount = 0;                      // MѱĶݒ
               }
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           break;

    case WM_TIMER:                           // *** ݒ莞 ***
           KillTimer(hwnd, ID_TIMER);            // ϰI
           devlast = numDevs;
           for(devcnt = 0;devcnt != devlast;devcnt++){
               ReadNum = 0;

               FT_GetStatus(ftHandle[devcnt],&ReadNum,&TransNum,&EventDword);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_GetStatus             *
                         // *      ReadNum ɎMςް擾           *
                         // *************************************************

               if(ReadNum > 0){                  // Mςް 1 ȏ̂Ƃ
                   Crt_GetDC();                  // DC̏ݒ (,,׼ = )
                   sprintf_s(buf,128,"M %1d  >>     ",devcnt);
                   TextOut(hDc,10,160+15*devcnt,buf,strlen(buf));

                   ftStatus = FT_Read(ftHandle[devcnt],buf,ReadNum,&RecNum);
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Read                  *
                         // *  bufɤReadNum ɂĎw肵ްǎ *
                         // *  RecNum ɂ͎ۂɎM߂          *
                         // *************************************************

                   r = RecNum;
                   s = ((int)buf[0]) & 0xff;
                   sprintf_s(buf,128,"%02x",s);        // Mް\̂16i2ɕϊ
                   TextOut(hDc,100,160+15*devcnt,buf,2);
                                                 // Mf[^\
                   Crt_ReleaseDC();              // DC̏Iݒ (,,׼ = )
                   RxTimecount = 0;              // MѱĶݒ
               }
           }
           RxTimecount = RxTimecount + 1;        // MѱĶ +1
           if(RxTimecount > 1000) RxTimecount = 1000;
           if(RxTimecount < 100) SetTimer(hwnd, ID_TIMER, 20, NULL);  // 20msecϰݒ
           break;

    case WM_PAINT:                           // IME ON  OFF łĂ΂
           hDc = BeginPaint(hwnd, &ps);          // WNDCLASS  hbrBackground ŕ`悳
                                                 // (InitApplication֐Őݒς)
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           EndPaint(hwnd, &ps);
           break;

    case WM_DESTROY:                         // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI
           devlast = numDevs;
           for(devcnt = 0;devcnt != devlast;devcnt++){

               ftStatus = FT_Close(ftHandle[devcnt]);  // ޲CLOSE
                         // *************************************************
                         // *   ޲ڸĔײފ֐ FT_Close                 *
                         // *      ޲CLOSE                            *
                         // *************************************************
               }
           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           return(DefWindowProc(hwnd, message, wParam, lParam));
           break;
  }

  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}


/******************************************************************************
   ֐   : int hextobin(int num,char *buf)
   Ұ : num HEXް
            *str HEXް  
      : HEXintɕϊ
   ߂l : ϊbinaryް   ُ̂Ƃ-1
******************************************************************************/

int hextobin(int num, char *buf)
{
    char  datatmp;
    int   cnt, tmp;
    int   ret = 0;

    if(num < 1) return(-1);
    for(cnt = 0; cnt != num; cnt++){
        datatmp = buf[cnt];
        tmp = -1;
        if((datatmp > 0x2f) && (datatmp < 0x3a)) tmp = datatmp - 0x30;
        if((datatmp > 0x40) && (datatmp < 0x47)) tmp = datatmp - 0x41 + 10;
        if((datatmp > 0x60) && (datatmp < 0x67)) tmp = datatmp - 0x61 + 10;
        if(tmp == -1) return(-1);
        else          ret = ret*16 + tmp; 
    }
    return(ret);
}
/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
