﻿using System;
using System.Timers;
using System.Windows.Forms;

namespace DacsE350LAN
{
    public partial class Form1 : Form
    {
        System.Timers.Timer recTimer;
        int connectf = 0;
        int iTimeOut = 0;

        // ネットワーク関連
        System.Net.Sockets.TcpClient tcp;
        System.Net.Sockets.NetworkStream ns;

        public Form1()
        {
            InitializeComponent();
            this.Text = "DACS-E350 LAN送受信サンプル";

            textBoxT.Text = "接続処理中 お待ちください";

            recTimer = new System.Timers.Timer();  // レスポンス受信処理用のタイマーをセット
            recTimer.Enabled = true;
            recTimer.AutoReset = true;
            recTimer.Interval = 10;
            recTimer.Elapsed += new ElapsedEventHandler(OnTimerEvent);

            ControlBox = false;                    // 閉じるボタンを無効にする
            CheckForIllegalCrossThreadCalls = false; // 別スレッドでテキストボックス変更を可能とする
            textBoxK.Focus();
        }

        // DACS-E350に接続

        private void E350Connect()
        {
            try
            {
                string ipOrHost = "socfpga";       // DACS-E350 ホスト名
                int port = 16831;                  // ポート番号 (DACS-E350と一致させる)
                tcp = new System.Net.Sockets.TcpClient(ipOrHost, port); // TcpClientを作成、サーバーと接続
            }
            catch
            {
                connectf = 1;                      // 接続失敗
            }
            if (connectf == 0)                     // サーバ接続が正常終了のとき
            {
                ns = tcp.GetStream();              // NetworkStreamを取得する

                // **** NET Framework 2.0以上が必要 ****
                ns.ReadTimeout = 1000;             // 読取りタイムアウト1秒
                ns.WriteTimeout = 1000;            // 書込みのタイムアウト1秒

                connectf = 2;                      // 接続完了とする
                textBoxT.Text = "接続完了";
            }
            else
            {
                connectf = 0;                     // 接続失敗のとき再試行とする
                textBoxT.Text = "接続試行中";
            }

        }

        // レスポンス受信処理 (タイマーイベント)
        
        private void OnTimerEvent(object source, ElapsedEventArgs e)
        {
            recTimer.Stop();                       // タイマー停止

            // DACS-E350(ホスト)に接続する処理

            if (connectf == 0)                     // 接続指示のとき
            {
                E350Connect();                     // DACS-E350に接続
                recTimer.Start();                  // タイマー開始
                return;
            }

            // DACS-E350からデータを受信する処理

            byte[] rxdata = new byte[16384];
            int rxSize;
            rxSize = 0;
            try
            {
                rxSize = ns.Read(rxdata, 0, 16000);   // データ受信
            }
            catch
            {
                if (iTimeOut == 1) textBoxR.Text = "受信タイムアウト";
            }
            if(rxSize > 0) textBoxR.Text = System.Text.Encoding.ASCII.GetString(rxdata); // 受信データ表示
            iTimeOut = 0;                          // 受信待ちを解除

            recTimer.Start();                      // タイマー開始
        }

        // コマンド送信処理 (キーを押したとき)

        private void textBoxK_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (connectf == 0) return;             // 接続試行中のときはなにもしない

            if (e.KeyCode == Keys.Return)          // Enter キーを押したとき
            {
                recTimer.Stop();                   // タイマー停止

                // キー入力した文字列をバイト配列にして、最後にCRコードを追加する

                byte[] data = System.Text.Encoding.ASCII.GetBytes(textBoxK.Text + "\r");
                ns.Write(data, 0, data.Length);    // データ送信

                textBoxT.Text = textBoxK.Text;     // 送信データ表示
                textBoxR.Text = "";
                textBoxK.Text = "";

                iTimeOut = 1;                      // 受信待ちとする
                recTimer.Start();                  // タイマー開始
            }

            if (e.KeyCode.ToString() == "D1")      // !(感嘆符)キーを押したとき (通常は使用しない)
            {
                connectf = 4;                      // 終了時にDACS-E350 の制御プログラム停止を指定
            }
        }

        // 終了処理
        
        private void button3_Click(object sender, EventArgs e)
        {
            if ((connectf == 2) || (connectf == 4))  // 接続が完了しているとき
            {
                byte[] data = new byte[256];
                if (connectf == 2) data[0] = 42;  // *(アスタリスク)を送信して接続終了をホストに通知する
                else               data[0] = 33;  // !(感嘆符)を送信してDACS-E350の制御プログラムを終了する
                data[1] = 13;
                ns.Write(data, 0, 2);

                ns.Close();                       // ネットワーク接続終了
                tcp.Close();
            }
            this.Close();                         // プログラム終了
        }
    }
}
