/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EEPROM_232R;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_232R_Ctrl
extends FT_EE_Ctrl {
    private static final short EEPROM_SIZE = 80;
    private static final short ENDOFUSERLOCATION = 63;
    private static final short EE_MAX_SIZE = 1024;
    private static final int EXTERNAL_OSCILLATOR = 2;
    private static final int HIGH_CURRENT_IO = 4;
    private static final int LOAD_D2XX_DRIVER = 8;
    private static final int INVERT_TXD = 256;
    private static final int INVERT_RXD = 512;
    private static final int INVERT_RTS = 1024;
    private static final int INVERT_CTS = 2048;
    private static final int INVERT_DTR = 4096;
    private static final int INVERT_DSR = 8192;
    private static final int INVERT_DCD = 16384;
    private static final int INVERT_RI = 32768;
    private static FT_Device ft_device;

    FT_EE_232R_Ctrl(FT_Device usbC) {
        super(usbC);
        ft_device = usbC;
    }

    boolean writeWord(short offset, short value) {
        int wValue = value & 0xFFFF;
        int wIndex = offset & 0xFFFF;
        int status = 0;
        boolean rc = false;
        byte latency = 0;
        if (offset >= 1024) {
            return rc;
        }
        latency = ft_device.getLatencyTimer();
        ft_device.setLatencyTimer((byte)119);
        status = ft_device.getConnection().controlTransfer(64, 145, wValue, wIndex, null, 0, 0);
        if (status == 0) {
            rc = true;
        }
        ft_device.setLatencyTimer(latency);
        return rc;
    }

    short programEeprom(FT_EEPROM ee) {
        if (ee.getClass() != FT_EEPROM_232R.class) {
            return 1;
        }
        int[] data = new int[80];
        FT_EEPROM_232R eeprom = (FT_EEPROM_232R)ee;
        try {
            byte c4;
            short i = 0;
            while (i < 80) {
                data[i] = this.readWord(i);
                i = (short)(i + 1);
            }
            int wordx00 = 0;
            wordx00 |= data[0] & 0xFF00;
            if (eeprom.HighIO) {
                wordx00 |= 4;
            }
            if (eeprom.LoadVCP) {
                wordx00 |= 8;
            }
            wordx00 = eeprom.ExternalOscillator ? (wordx00 |= 2) : (wordx00 &= 0xFFFD);
            data[0] = wordx00;
            data[1] = eeprom.VendorId;
            data[2] = eeprom.ProductId;
            data[3] = 1536;
            data[4] = this.setUSBConfig(ee);
            int wordx05 = this.setDeviceControl(ee);
            if (eeprom.InvertTXD) {
                wordx05 |= 0x100;
            }
            if (eeprom.InvertRXD) {
                wordx05 |= 0x200;
            }
            if (eeprom.InvertRTS) {
                wordx05 |= 0x400;
            }
            if (eeprom.InvertCTS) {
                wordx05 |= 0x800;
            }
            if (eeprom.InvertDTR) {
                wordx05 |= 0x1000;
            }
            if (eeprom.InvertDSR) {
                wordx05 |= 0x2000;
            }
            if (eeprom.InvertDCD) {
                wordx05 |= 0x4000;
            }
            if (eeprom.InvertRI) {
                wordx05 |= 0x8000;
            }
            data[5] = wordx05;
            int wordx0A = 0;
            byte c0 = eeprom.CBus0;
            int c1 = eeprom.CBus1;
            int c2 = eeprom.CBus2;
            int c3 = eeprom.CBus3;
            data[10] = wordx0A = c0 | (c1 <<= 4) | (c2 <<= 8) | (c3 <<= 12);
            byte wordx0B = 0;
            wordx0B = c4 = eeprom.CBus4;
            data[11] = wordx0B;
            int saddr = 12;
            saddr = this.setStringDescriptor(eeprom.Manufacturer, data, saddr, 7, true);
            saddr = this.setStringDescriptor(eeprom.Product, data, saddr, 8, true);
            if (eeprom.SerNumEnable) {
                saddr = this.setStringDescriptor(eeprom.SerialNumber, data, saddr, 9, true);
            }
            byte latency = 0;
            if (data[1] != 0 && data[2] != 0) {
                boolean returnCode = false;
                latency = ft_device.getLatencyTimer();
                ft_device.setLatencyTimer((byte)119);
                returnCode = this.programEeprom(data, 80);
                ft_device.setLatencyTimer(latency);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    FT_EEPROM readEeprom() {
        FT_EEPROM_232R eeprom = new FT_EEPROM_232R();
        int[] data = new int[80];
        try {
            int i = 0;
            while (i < 80) {
                data[i] = this.readWord((short)i);
                ++i;
            }
            eeprom.HighIO = (data[0] & 4) == 4;
            eeprom.LoadVCP = (data[0] & 8) == 8;
            eeprom.ExternalOscillator = (data[0] & 2) == 2;
            eeprom.VendorId = (short)data[1];
            eeprom.ProductId = (short)data[2];
            this.getUSBConfig(eeprom, data[4]);
            this.getDeviceControl(eeprom, data[5]);
            eeprom.InvertTXD = (data[5] & 0x100) == 256;
            eeprom.InvertRXD = (data[5] & 0x200) == 512;
            eeprom.InvertRTS = (data[5] & 0x400) == 1024;
            eeprom.InvertCTS = (data[5] & 0x800) == 2048;
            eeprom.InvertDTR = (data[5] & 0x1000) == 4096;
            eeprom.InvertDSR = (data[5] & 0x2000) == 8192;
            eeprom.InvertDCD = (data[5] & 0x4000) == 16384;
            eeprom.InvertRI = (data[5] & 0x8000) == 32768;
            int cbus0 = data[10] & 0xFF;
            eeprom.CBus0 = (byte)cbus0;
            int cbus1 = data[10] & 0xFF00;
            eeprom.CBus1 = (byte)(cbus1 >> 4);
            int cbus2 = data[10] & 0xFF0000;
            eeprom.CBus2 = (byte)(cbus2 >> 8);
            int cbus3 = data[10] & 0xFF000000;
            eeprom.CBus3 = (byte)(cbus3 >> 12);
            int cbus4 = data[11] & 0xFF;
            eeprom.CBus4 = (byte)cbus4;
            int addr = data[7] & 0xFF;
            addr -= 128;
            eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, data);
            addr = data[8] & 0xFF;
            addr -= 128;
            eeprom.Product = this.getStringDescriptor(addr /= 2, data);
            addr = data[9] & 0xFF;
            addr -= 128;
            eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, data);
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    int getUserSize() {
        int data = this.readWord((short)7);
        int ptr07 = (data & 0xFF00) >> 8;
        data = this.readWord((short)8);
        int ptr08 = (data & 0xFF00) >> 8;
        int ptr = 12 + (ptr07 /= 2) + (ptr08 /= 2) + 1;
        data = this.readWord((short)9);
        int length = (data & 0xFF00) >> 8;
        return (63 - ptr - (length /= 2) - 1) * 2;
    }

    int writeUserData(byte[] data) {
        int dataWrite = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        short offset = (short)(63 - this.getUserSize() / 2 - 1);
        offset = (short)(offset & 0xFFFF);
        int i = 0;
        while (i < data.length) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(s + 1);
            this.writeWord(s, (short)(dataWrite |= data[i] & 0xFF));
            i += 2;
        }
        return data.length;
    }

    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(63 - this.getUserSize() / 2 - 1);
        offset = (short)(offset & 0xFFFF);
        int i = 0;
        while (i < length) {
            short s = offset;
            offset = (short)(s + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
            i += 2;
        }
        return data;
    }
}

