# CRP25KB_sub

# カウンタ計測ソフト CPR25KB と連携して、ファイル入力にてカウンタ値を連続して読取る
#     ファイル CPR25KBDI.csv からデジタル入力データを読取る
#     ファイル CPR25KBCN.csv からカウンタデータを読取る

#     キー入力 0(enter) にて、カウンタデータ ch0～2 を表示
#              1(enter) にて、カウンタデータ ch3～5 を表示
#              2(enter) にて、デジタル入力データを表示
#     それ以外のキー入力(enter) にてプログラム終了

# ファイル CPR25KBDI.csv、CPR25KBCN.csv をOPENするときの注意
#     (1) カウンタ計測ソフト CPR25KB が書込中のことがあるので、
#         例外(error)処理をして、再試行が必要。
#     (2) open -> read 後に、必ず(すみやかに) close すること。

import time
import msvcrt

disp = '0'                  # 表示項目選択 '0':ch0～2,'1':ch3～5,'2':Din
disp1 = '  |    ch0    |    ch1    |    ch2    |    hd0    |    hd1    |    hd2    |'
disp2 = '  |    ch3    |    ch4    |    ch5    |    hd3    |    hd4    |    hd5    |'
disp3 = '  |  Din |wait|                                                            '
print(disp1)

data1 = ' '*8               # 表示データ初期化
data2 = ' '*143

while True:
    # キー入力を検出する
    
    if msvcrt.kbhit():      # キー入力があったとき
        print(' ')
        kydata = input()    # キー入力を読取る
        disp = kydata[0:1]  # 最初の1文字を選択
        if disp == '0':
            print(disp1)    # '0'のとき 表示項目をカウンタ ch0～2 とする
        elif disp == '1':
            print(disp2)    # '1'のとき 表示項目をカウンタ ch3～5 とする
        elif disp == '2':
            print(disp3)    # '2'のとき 表示項目をデジタル入力とする
        else:
            break           # それ以外の入力にてプログラム終了

    # ファイルの読取りを連続して繰返す

    for cnt in range(4):    # 入力データファイルの読取りができるまで、最大4回繰返す
        try:
            fp = open('CPR25KBDI.csv', 'rt')   # ファイル CPR25KBDI.csv をopen
        except:
            time.sleep(0.04)                   # open できないとき
            continue                           # 40ms 後に再試行
        else:
            data1 = fp.read()                  # open できたとき、データを読取る
            fp.close()                         # ファイルをclose
            break                              # 読取り正常終了。forループを抜ける
    else:
        data1 = ' '*8       # 4回の試行が失敗したとき、データを初期化

    for cnt in range(4):    # カウンタデータファイルの読取りができるまで、最大4回繰返す
        try:
            fp = open('CPR25KBCN.csv', 'rt')   # ファイル CPR25KBCN.csv をopen
        except:
            time.sleep(0.04)                   # open できないとき
            continue                           # 40ms 後に再試行
        else:
            data2 = fp.read()                  # open できたとき、データを読取る
            fp.close()                         # ファイルをclose
            break                              # 読取り正常終了。forループを抜ける
    else:
        data2 = ' '*143     # 4回の試行が失敗したとき、データを初期化

    # 読取り結果を表示

    if disp == '2':         # 表示項目選択が '2' のとき
        datas = '   ' + data1[0:8] + ' '*64    # デジタル入力データを表示
    else:
        if disp == '0':     # 表示項目選択が '0' のとき
            datas = '   ' + data2[0:71]        # カウンタデータ ch0～2 を表示
        else:               # 表示項目選択が '1' のとき
            datas = '   ' + data2[72:143]      # カウンタデータ ch3～5 を表示
    print(datas,end='\r')   # データを表示
    time.sleep(0.2)         # 200ms 待機
