# DACS-2500K-CNT カウンタ サンプルプログラム

# Windows10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# d15cnt.py と FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# d15cnt.py を起動すると

# カウント開始コマンドを自動送信します。
# カウンタ値読取りコマンドを自動送信し、
#     カウンタ値を読取って連続表示します。
# 0～2番のカウンタ値とホールド値を表示します。

# 1 enter とキー入力すると
#    0～5番のカウンタ値表示に変わります。
# 0 enter とキー入力すると
#    0～2番のカウンタ値とホールド値に戻ります。
# W0000000(enter)などのコマンド文字列入力にて
#    デバイスを操作することができます。
#    例: M018(enter) と入力すると
#    カウンタ0番がエンコーダモードになります。
# 表示を一時停止するときはスペースキーなどを押す
#    enter にて表示再開

# enter のみをキー入力するとプログラムが終了します。

import FT
import msvcrt
import time

# デバイスをOPEN
handle = FT.init_dacs(0)
if handle.value == None:
    print('no device')
    exit()
    
# カウント開始を送信
writedata = 'M008&M028&M048&m008&m028&m048' + chr(0xd)
readdata = FT.transfer_dacs(handle, writedata, 54)
if len(readdata) != 54:     # (9文字)X(6コマンド)=54
    print('time-out error') # タイムアウトエラー
    FT.close_dacs(handle)   # 接続終了
    exit()                  # 応答がないときは終了

# 3ch(0～2番)カウンタ値と3ch(0～2番)ホールド値を取得するコマンド文字列を準備
c1command = 'M00&M01&M02&M03&M04&M05&M06&M07&M08&M09&M0A&M0B' + chr(0xd)
# 3ch(0～5番)カウンタ値を取得するコマンド文字列を準備
c2command = 'M00&M01&M02&M03&M04&M05&m00&m01&m02&m03&m04&m05' + chr(0xd)

dispmode = 0                # 表示内容選択  0:disp1  1:disp2
dcommand = c1command        # 送信要求コマンド文字列をdisp1用とする

disp1 = '|    ch0    |    ch1    |    ch2    |    hd0    |    hd1    |    hd2    |'
disp2 = '|    ch0    |    ch1    |    ch2    |    ch3    |    ch4    |    ch5    |'
print(disp1)                # カウンタ番号を画面表示

# コマンドコードのリスト(キー入力チェック用)
comlist = ['W','P','M','m','T','Y','I']

# カウンタ値の取得と画面表示を繰返す
while True:
    time.sleep(0.01)

    # カウンタ値を取得。受信文字数：(9文字)X(12コマンド)=108
    readdata = FT.transfer_dacs(handle, dcommand, 108)

    if len(readdata) != 108 or readdata[0:1] != 'N':
        # エラーのとき、コマンドを送信し、残留データを読み切る
        time.sleep(1)
        readdata = FT.transfer_dacs(handle, 'W0000000'+chr(0xd), 0)
        if len(readdata) < 9: # それでも応答がないとき
            print("")
            print('time-out error')
            break;          # ループを終了
        else:
            continue;       # 応答があればループを継続

    # 正常にデータを受信したとき
    sdata = ''              # 画面表示用の文字列を初期化

    for cnt in range(6):
        p = cnt*18 + 4      # カウンタ値文字列中の位置

        # 16進数下位4桁文字列を10進数の整数に変換
        try:
            cdata = int(readdata[(p):(p+4)],16)
        except ValueError:
            break

        # 16進数上位4桁文字列を10進数の整数に変換
        p += 9
        try:
            hdata = int(readdata[(p):(p+4)],16)
        except ValueError:
            break
        cdata = cdata + hdata*0x10000

        # 32bit長の負数処理
        if cdata > 0x7fffffff:
            cdata = cdata - 0x100000000

        # 画面表示用に12桁の文字列で連結する
        sdata = sdata + ("{:12d}".format(cdata))

    # カウンタ値を画面表示
    if len(sdata) == 72:    # 正常データのとき
        print(sdata,end='\r')
    else:                   # 不正データのとき
        print('data error'+' '*62)
        time.sleep(2)

    # キー入力があったときの処理
    if msvcrt.kbhit():
        print('')

        # キー入力文字にCRコードを付加
        kydata = input() + chr(0xd)
        c1 = kydata[0:1]    # 最初の1文字

        # コマンド文字列の場合
        if c1 in comlist and len(kydata) > 2:
            # キー入力データを送信し応答を受信
            readdata = FT.transfer_dacs(handle, kydata, 0)
            print(readdata) # 応答を画面表示

        # enterのみのときは終了
        elif c1 == chr(0xd):
            break

        # 先頭が0または1
        elif c1 == '0':
            dispmode = 0
            # 送信要求コマンド文字列をdisp1用に
            dcommand = c1command
        elif c1 == '1':
            dispmode = 1
            # 送信要求コマンド文字列をdisp2用に
            dcommand = c2command

        # カウンタ番号再表示
        if dispmode == 0:
            print(disp1)
        else:
            print(disp2)

# デバイスをCLOSE
FT.close_dacs(handle)
