# DACS-2500K(KB) モーションコントローラ サンプルプログラム

# Windows11/10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# Dpmv_sample.py、Dpmv.py、FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# Dpmv_sample.py を起動すると
# 各軸移動量を初期化します。
#    電源投入時に、デバイス側でも初期化をしますが、
#    このプログラムでの初期化処理は、
#        デバイスを再接続しないで、
#        プログラムを再起動した場合の対策です。

# 位置読取りコマンドを自動送信し、
#    6軸分の位置を読取って連続表示します。

# M enter とキー入力すると
#    移動量表示に変わります。
# P enter とキー入力すると
#    位置表示に戻ります。
# 表示を一時停止するときは PまたはMを押す
#    enter にて表示再開

# 以下のキー入力後、enterにて指示データを送信
# /(スラッシュ)で複数の指示データを連結可能 例 1,100/2,-1000
# x,y--y 各軸の移動量を指定
#      x:軸番号(1～6)  y--y:移動量(単位 パルス)
#      x=9 のとき、全軸に同じ移動量をセット
# V,y--y 移動速度を指定(単位 Hz)
# A,y--y 加速度を指定(単位 KHz/s)
# G 移動開始
# S 強制停止
# その他の操作詳細は、Dpmv.py 関数の注釈をご覧ください。

# -(マイナス) enter にてプログラム終了

import msvcrt
import time
import Dpmv

# デバイスをOPEN、各軸移動量を初期化
ret = Dpmv.Dpmv_init(9)
if ret[0] == 'OK':
    handle = ret[1]         # デバイスハンドルをセット
    print('OK')
else:
    print('no device')
    time.sleep(3)
    exit()

dispmode = 'P'              # 表示内容選択  M:移動量表示  P:位置表示
disp1 = '|  m.1  |  m.2  |  m.3  |  m.4  |  m.5  |  m.6  |  DI   |A 6 state|'
disp2 = '|  p.1  |  p.2  |  p.3  |  p.4  |  p.5  |  p.6  |  DI   |A 6 state|'

# | m.1～6| 各軸移動量  | p.1～6| 各軸位置
# |  DI   |  デジタル入力 bit23～0を16進6桁表示
# |A 6 state|
#  A:全軸の移動状態 6:第6軸独立動作状態 state:ステータス(16進下位5桁表示)

print(disp2)                # 軸番号などを画面表示

# 移動量または位置、デジタル入力、ステータスの画面表示を繰返す
while True:
    time.sleep(0.01)

    # 移動量または位置とデジタル入力を取得
    readdata = Dpmv.Dpmv_read(handle, dispmode)
    # ステータスを取得
    sreaddata = Dpmv.Dpmv_sread(handle)

    # 1軸から6軸までの移動量または位置とデジタル入力、ステータスを表示
    if len(readdata) != 0 and len(sreaddata) != 0:  # 正常データのとき
        pdata = readdata.split(',')      # ',' で分離
        sdata = ''
        for cnt in range(7):       # 1行に連結
            sdata = sdata + ' '*(8-len(pdata[cnt])) + pdata[cnt]
        print(sdata + ' ' + sreaddata,end='\r')
    else:                          # 不正データのとき
        print('connection error'+' '*50)
        time.sleep(2)
    if not msvcrt.kbhit():         # キー入力のないとき
        continue

    # キー入力があったとき
    print('')
    kydatabuf = input()
    # マイナスキー入力のときは終了
    if kydatabuf == '-':
        break
    if len(kydatabuf) != 0:
        # MまたはPの1文字のときは、表示内容セット
        c1 = kydatabuf.upper()
        if c1 == 'M' or c1 == 'P':
            dispmode = c1         # 表示内容セット
        # 指示データ送信
        else:
            if kydatabuf[0:1].upper() == 'M':   # MOVE MDまたはMI 送信
                if kydatabuf[2:3] == '6':       # 6軸単独動作
                    readdata = Dpmv.Dpmv_move6(handle, kydatabuf)
                else:                           # 全軸動作
                    readdata = Dpmv.Dpmv_moveA(handle, kydatabuf)
            else:                               # コマンド送信
                readdata = Dpmv.Dpmv_write(handle, kydatabuf)
            # 応答結果を表示
            if readdata[0:2] == 'OK':
                print(readdata)
            else:
                if readdata == 'ER':
                    ms = 'connection error'
                elif readdata == 'NA':
                    ms = 'moving error'
                else:
                    ms = 'data error'
                print('\033[31m'+kydatabuf+'-->' + ms + '\033[0m')
    # 移動量または位置の軸番号などを表示
    if dispmode == 'M':
        print(disp1)              # 移動量の軸番号を表示
    else:
        print(disp2)              # 位置の軸番号を表示

# デバイスをCLOSE
Dpmv.Dpmv_close(handle)
