﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FTD2XX_NET;       // 参照設定に FTD2XX_NET.dll を登録し、この1行を追加する

namespace DacsTxRx
{
    public partial class Form1 : Form
    {
        uint DevNum = 0;
        FTD2XX_NET.FTDI ftDev = new FTDI();
        FTDI.FT_STATUS ftStatus = FTDI.FT_STATUS.FT_OK;

        public Form1()
        {
            InitializeComponent();
            this.Text = "DACS 送受信サンプル";

            // FTDI社のUSBチップを使用しているデバイスが1個のみで、接続エラーの確認も必要ないときは
            // 下記の注釈行となっている1行のみでもデバイスのOPENができますが推奨はしません。

            //ft245.OpenByIndex(0);
            ftDevOpenDacs();            // DACS製品を選択してOPENします。
            if (DevNum == 0) textBoxT.Text = "デバイス接続なし";
            textBoxK.Focus();
        }

        private void ftDevOpenDacs()    // DACS製品を選択してOPEN
        {
            ftDev.GetNumberOfDevices(ref DevNum);     // ** 接続デバイス数を取得 **

            if (DevNum != 0)                          // 接続デバイスがあるとき
            {
                FTDI.FT_DEVICE_INFO_NODE[] ftList = new FTDI.FT_DEVICE_INFO_NODE[DevNum];
                ftDev.GetDeviceList(ftList);          // ** 接続デバイスの情報リストを取得 **

                int r;
                string SnoHead;
                for (r = 0; r != DevNum; r++)
                {
                    if (ftList[r].SerialNumber.Length != 8) continue;   // シリアル番号が8文字であること
                    SnoHead = ftList[r].SerialNumber.Substring(0, 1);   // シリアル番号の先頭1文字を取出す

                    // シリアル番号の確認

                    if (SnoHead == "D")
                    {
                        ftStatus = ftDev.OpenBySerialNumber(ftList[r].SerialNumber);  // ** シリアル番号でOPEN **
                        if (ftStatus != FTDI.FT_STATUS.FT_OK) continue;
                        ftStatus = ftDev.SetCharacters(0xd, true, 0, false);          // ** イベント文字(CR)を設定 **
                        if (ftStatus == FTDI.FT_STATUS.FT_OK) break;                  // 正常であればOPEN処理を終了する
                    }
                }
                if (r == DevNum) DevNum = 0;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (DevNum == 0) return;

            // キー入力した文字列をバイト配列にして、最後にCRコードを追加する

            byte[] data = System.Text.Encoding.ASCII.GetBytes(textBoxK.Text + "\r");
            uint Writtten = 0;
            ftStatus = ftDev.Write(data, data.Length, ref Writtten);  // ** データ送信 **

            textBoxT.Text = textBoxK.Text;
            textBoxR.Text = "";
            textBoxK.Text = "";

            if (ftStatus != FTDI.FT_STATUS.FT_OK)
            {
                textBoxT.Text = "送信できません";
                return;
            }

            uint ReadAb = 0;
            uint ReadBy = 0;
            int r = 0;
            int iTimeOut = 10;
            byte[] rxdata = new byte[256];
            for (r = 0; r < iTimeOut; r++)
            {
                ftDev.GetRxBytesAvailable(ref ReadAb);                   // ** 受信データ数を取得 **

                // 受信データ数が9文字以上(正常)か、時間が経過しても1文字以上で8文字以下(異常)のとき

                if ((ReadAb >= 9) || (ReadAb > 0) && (r > iTimeOut / 2))
                {
                    ftStatus = ftDev.Read(rxdata, ReadAb, ref ReadBy);   // ** 受信データ読取り **
                    if (ftStatus == FTDI.FT_STATUS.FT_OK)
                        textBoxR.Text = System.Text.Encoding.ASCII.GetString(rxdata);
                    else textBoxR.Text = "受信できません";
                    break;
                }
                System.Threading.Thread.Sleep(10);
            }
            if (r > iTimeOut / 2)
            {
                if (r == iTimeOut) textBoxR.Text = "受信タイムアウト";
                else textBoxR.Text = textBoxR.Text + " 受信文字不足";
            }
            textBoxK.Focus();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            ftDev.Close();       // ** デバイスをCLOSE **
            textBoxT.Text = "";
            textBoxR.Text = "";
            textBoxK.Text = "";
            ftDevOpenDacs();     // 再度OPEN
            if (DevNum == 0) textBoxT.Text = "デバイス接続なし";
            textBoxK.Focus();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            ftDev.Close();       // ** デバイスをCLOSE **
            this.Close();        // プログラム終了
        }

    }
}
