# DACS-2500KB デジタル入出力

# Raspberry pi の Python にて動作
# DACS USBデバイスドライバをインストール済とします。
# Ddio_rpi.py と FT_rpi.py を同じディレクトリに格納

import FT_rpi
bdID = '0'                # ID番号(検索結果)

def Ddio_init(devnum):
# 関数 デバイスのOPEN
#    引数   : デバイス番号(int型)
#    戻り値 : (1)'OK' 正常終了 'NG' 異常 ,(2)デバイスハンドル

    ret = 'NG'            # 仮に異常終了とする
    for cnt in range(4):  # 4デバイス分の検索
        if devnum >= 9:
            devn = cnt
        else:             # デバイス番号を指定している
            devn = devnum
        handle = FT_rpi.init_dacs(devn)
        if handle.value != None:
            # デジタル入力を実行してデジタル入出力デバイスの確認
            readdata = FT_rpi.transfer_dacs(handle, 'W0Rxxxxx'+chr(0xd), 9)
            if (len(readdata) == 9) and (readdata[0:1] == 'R'):
                # Mコマンドの応答がないことを確認(カウンタではない)
                readdata = FT_rpi.transfer_dacs(handle, 'M00'+chr(0xd), 9)
                if len(readdata) == 0 or len(readdata) != 0\
                   and (readdata[0:1] != 'N'):
                    # qコマンドの応答がないことを確認
                    # (PWMパルス出力、モーションコントローラではない)
                    readdata = FT_rpi.transfer_dacs(handle, 'q0R'+chr(0xd), 9)
                    if len(readdata) == 0 or len(readdata) != 0\
                       and (readdata[0:1] != 'n') and (readdata[0:1] != 's'):
                        ret = 'OK'
                readdata = FT_rpi.transfer_dacs(handle, 'W0Rxxxxx'+chr(0xd), 9)
                if ret == 'OK':
                    break
            FT_rpi.close_dacs(handle)   # デバイスをCLOSE
        if devnum < 9:
            break
    return ret,handle

def Ddio_initID(IDnum):
# 関数 デバイスのOPEN ID番号使用
#    引数   : ID番号(16進数1文字 '0'～'F')
#    戻り値 : (1)'OK' 正常終了 'NG' 異常 ,(2)デバイスハンドル

    global bdID           # ID番号(検索結果)

    ret = 'NG'            # 仮に異常終了とする
    for cnt in range(4):  # 4デバイス分の検索
        handle = FT_rpi.init_dacs(cnt)
        if handle.value != None:
            # ROM読取りを実行してID番号確認
            readdata = FT_rpi.transfer_dacs(handle, '*$200000'+chr(0xd), 9)
            if (len(readdata) == 9) and (readdata[0:1] == '^'):
                try:
                    if readdata[1:2] == IDnum:
                        bdID = IDnum    # ID番号(検索結果)セット
                        ret = 'OK'
                        break
                except ValueError:
                        pass
            FT_rpi.close_dacs(handle)   # デバイスをCLOSE
    return ret,handle

def Ddio_write(handle, wdata):
# 関数 コマンド送信とレスポンス受信
#    引数   : デバイスハンドル, 指示データ
#    戻り値 : デジタル入力(16進数6桁 bit23～0)

# /(スラッシュ)で複数の指示データを連結可能  例 IT,500000/DW,56AF01/DW,06AF00

#     DW,y--y    デジタル出力とデジタル入力 y--y デジタル出力(16進数6桁 bit23～0)
#                y--y が6桁未満の場合はbit23からの指定、以降は未指定にて変化なし
#     DR         デジタル入力のみ
#     WP,x,y--y  PWM出力パルス幅設定  デジタル出力bit0：ch0  bit1：ch1
#                x チャンネル番号(0または1)  y--y パルス幅(整数値 単位: 1us)
#     G          パルス出力開始       デジタル出力bit0、bit1がPWMパルス出力
#     N          パルス出力終了(初期状態)    bit0、bit1が汎用デジタル出力
#     IT,y--y    コマンド実行間隔設定  y--y コマンド実行間隔(整数値 単位: 1us)

    global boardID        # ID番号(検索結果)

    cdatalist = wdata.split('/')    # '/' で分離
    alltdata = ''                   # コマンド文字列の準備

    for cntlist in range(len(cdatalist)):       # 指示データ数分の繰返し
        cdata = cdatalist[cntlist].split(',')   # ',' で分離
        cnum = len(cdata)                 # ','で分離したデータ個数
        if cnum == 0:                     # データ異常とする
            alltdata = ''
            break
        if len(cdata[0]) == 0:            # データ異常とする
            alltdata = ''
            break
        ca = cdata[0].upper()             # ,'で分離した先頭データ

        # コマンド文字列に変換
        edata = 0                         # 仮に不正データとする

        if ca == 'DW' and cnum == 2:      # デジタル出力(bit23～0)設定
            if len(cdata[1]) < 7:
                tdata = 'W' + bdID + cdata[1] + '&'
                edata = 1                 # 正常データとする
        elif ca == 'DR' and cnum == 1:    # デジタル入力のみ
            tdata = 'W' + bdID + 'R' + '&'
            edata = 1                     # 正常データとする
        elif ca == 'WP' and cnum == 3:    # PWMパルス幅設定
            if len(cdata[1]) == 1 and len(cdata[2]) != 0:
                if cdata[1] == '0' or cdata[1] == '1':
                    try:
                        pwdata = int(cdata[2])  # パルス幅(クロック数)
                        if pwdata >= 0 and pwdata < 4096:
                            tdata = 'P' + bdID + 'xx' + cdata[1] + format(pwdata,'03X') + '&'
                            edata = 1     # 正常データとする
                    except ValueError:
                        pass
        elif ca == 'G' and cnum == 1:     # PWMパルス出力開始
            tdata = 'P' + bdID +'xxAxxx&' #   bit13 ONでパルス幅指定無効
            edata = 1                     # 正常データとする
        elif ca == 'N' and cnum == 1:     # PWMパルス出力終了
            tdata = 'P' + bdID +'xx6xxx&' #   bit13 ONでパルス幅指定無効
            edata = 1                     # 正常データとする
        elif ca == 'IT' and cnum == 2:    # 実行間隔設定
            if len(cdata[1]) != 0:
                try:
                    itdata = int(cdata[1])      # パルス幅(クロック数)
                    if itdata >= 0 and itdata < 1048576:
                        tdata = 'I' + bdID +'0'+ format(itdata,'05X') + '&'
                        edata = 1               # 正常データとする
                except ValueError:
                    pass
        if edata == 1:
            alltdata = alltdata + tdata   # コマンド文字列の連結
        else:
            alltdata = ''
            break

    # 正常な入力データのときコマンドを送信
    ret = ''                              # 仮にデータ送受信エラーとする
    if len(alltdata) != 0:
        num = alltdata.count('&')         # コマンド数
        alltdata = alltdata[:-1] + chr(0xd)    # 末尾の'&'文字をCRに置換
        readdata = FT_rpi.transfer_dacs2(handle, alltdata, num*9)
        if len(readdata) == num*9:
            for cnt in range(num):        # 受信データを / で連結
                ret = ret + 'DI,'+ readdata[cnt*9+2:cnt*9+8] + '/'
            ret = ret[:-1]                # 末尾の / を削除
    return ret

def Ddio_close(handle):
# 関数 デバイスをCLOSE
#    引数   : デバイスハンドル
#    戻り値 : なし

    FT_rpi.close_dacs(handle)
