import os
import ctypes
import time

# 関数 デバイスの初期化
#     引数   : デバイス番号(int型)
#     戻り値 : デバイスハンドル

def init_dacs(devnum):
    os.system('sudo modprobe -r ftdi_sio')        # 仮想COMドライバを登録からはずす
                                                  #   ダイレクト版を動作可能とするため
    dll = ctypes.CDLL('/usr/local/lib/libftd2xx.so')
    hdl = ctypes.c_void_p()                       # デバイスハンドルの準備
    res = dll.FT_Open(ctypes.c_ulong(devnum), ctypes.pointer(hdl))
    if res == 0:                                  # 正常にOPENできたとき
        res = dll.FT_SetChars(hdl, 0xd, 1, 0, 0)  # 区切り文字(0xd)を指定
        res = dll.FT_SetTimeouts(hdl, 100, 100)   # タイムアウト時間(msec)を指定

        # **** DACS-8200 ****
        #res = dll.FT_SetBaudRate(hdl, 1382400)
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-9600K ****
        #res = dll.FT_SetBaudRate(hdl, 230400);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 2, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-9600 ****
        #res = dll.FT_SetBaudRate(hdl, 38400);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0100, 0, 0)

        # **** DACS-E350-STD ****
        #res = dll.FT_SetBaudRate(hdl, 115200);
        #res = dll.FT_SetDataCharacteristics(hdl, 8, 0, 0)
        #res = dll.FT_SetFlowControl(hdl, 0x0400, 0x11, 0x13)

    return hdl

# 関数 データ送信と応答受信
#     引数1  : デバイスハンドル
#     引数2  : 送信データ文字列  文字数が1以下のときは送信なし
#     引数3  : 最少受信データ数(int型)
#                -1    : 受信なし
#                 0    : 待ち時間100msの後に、受信データをすべて取得(最大1000byte)
#                 1以上: 指定文字数分のデータを受信
#                        指定文字数のデータがすでにあれば、待ち時間なし
#                        指定文字数を受信するまで、待ち時間10msで最大50回くり返し
#     戻り値 : 受信データ文字列

def transfer_dacs(hdl, wdata, rnum):
    dll = ctypes.cdll.LoadLibrary('/usr/local/lib/libftd2xx.so')

    # **** データ送信 ****

    if len(wdata) > 1:
        # 送信する文字列をASCII文字列に変換
        wdatabuf = ctypes.create_string_buffer(wdata.encode('ascii'))
        wrnum = ctypes.c_ulong(0)    # 送信した文字数の格納場所を準備
        # 送信実行
        dll.FT_Write(hdl, ctypes.pointer(wdatabuf), ctypes.c_ulong(len(wdatabuf)-1), ctypes.pointer(wrnum))

    # **** データ受信 ****

    rdata = ''                       # 受信データ文字列を空にする
    if rnum < 0:
        return rdata                 # 送信のみのときは終了

    rqnum = ctypes.c_ulong(0)        # 受信済み文字数の格納場所を準備
    trnum = ctypes.c_ulong(0)
    event = ctypes.c_ulong(0)

    for cnt in range(50):            # 受信待ちループ
        # 受信データ数の確認
        dll.FT_GetStatus(hdl, ctypes.pointer(rqnum), ctypes.pointer(trnum), ctypes.pointer(event))
        if rnum == 0 and cnt == 0 and rqnum.value < 1000:
            # 受信データ数の指定なしで、過大な残留データがないときのみ、
            time.sleep(0.1)          #     受信データ数の確認前に十分長い時間待ちをする
            # 時間待ち後の受信データ数を確認
            dll.FT_GetStatus(hdl, ctypes.pointer(rqnum), ctypes.pointer(trnum), ctypes.pointer(event))

        # 受信データ数が指定数と同じか超えたとき
        if rqnum.value >= rnum:
            if rqnum.value > 0:
                # 受信データを格納するASCII文字列領域を準備
                rdatabuf = ctypes.create_string_buffer((' '*1024).encode('ascii'))
                rdnum = ctypes.c_ulong(0)       # 受信した文字数の格納場所を準備
                # 受信データを取得
                if rnum > 0:
                    rqnum.value = rnum          # 受信文字数指定のとき
                if rqnum.value > 1024:
                    rqnum.value = 1000          # 最大データ数をバッファサイズに制限
                dll.FT_Read(hdl, ctypes.pointer(rdatabuf), rqnum, ctypes.pointer(rdnum))
                # 受信データ領域から受信データ数分のデータを抽出し、cp932コード文字列に変換
                if rdnum.value != 0:
                    rdata = ((rdatabuf.value)[0:(rdnum.value)]).decode('cp932')
            break                    # 受信待ちループ終了
        time.sleep(0.01)             # 短い待ち時間
    return rdata

# 関数 データ送信と応答受信(長いコマンド実行間隔対応)
#     引数1  : デバイスハンドル
#     引数2  : 送信データ文字列
#     引数3  : 最少受信データ数(int型)
#                        指定文字数分のデータを受信
#                        指定文字数のデータがすでにあれば、待ち時間なし
#                        受信データ数が増加中であれば待ち時間タイマーをリセット
#                        指定文字数を受信するまで、待ち時間10msで最大105回くり返し
#     戻り値 : 受信データ文字列

def transfer_dacs2(hdl, wdata, rnum):
    dll = ctypes.cdll.LoadLibrary('/usr/local/lib/libftd2xx.so')

    # **** データ送信 ****

    if len(wdata) > 1:
        # 送信する文字列をASCII文字列に変換
        wdatabuf = ctypes.create_string_buffer(wdata.encode('ascii'))
        wrnum = ctypes.c_ulong(0)    # 送信した文字数の格納場所を準備
        # 送信実行
        dll.FT_Write(hdl, ctypes.pointer(wdatabuf), ctypes.c_ulong(len(wdatabuf)-1), ctypes.pointer(wrnum))

    # **** データ受信 ****

    rdata = ''                       # 受信データ文字列を空にする

    rqnum = ctypes.c_ulong(0)        # 受信済み文字数の格納場所を準備
    trnum = ctypes.c_ulong(0)
    event = ctypes.c_ulong(0)
    rqnumtmp = 0                     # 前の受信済み文字数
    tcnt = 0                         # タイムアウトカウンタ

    while True:                      # 受信待ちループ
        # 受信データ数の確認
        dll.FT_GetStatus(hdl, ctypes.pointer(rqnum), ctypes.pointer(trnum), ctypes.pointer(event))
        # 受信データ数が指定数と同じか超えたとき
        if rqnum.value >= rnum:
            if rqnum.value > 0:
                # 受信データを格納するASCII文字列領域を準備
                rdatabuf = ctypes.create_string_buffer((' '*1024).encode('ascii'))
                rdnum = ctypes.c_ulong(0)       # 受信した文字数の格納場所を準備
                # 受信データを取得
                rqnum.value = rnum              # 指定受信文字数設定
                if rqnum.value > 1024:
                    rqnum.value = 1000          # 最大データ数をバッファサイズに制限
                dll.FT_Read(hdl, ctypes.pointer(rdatabuf), rqnum, ctypes.pointer(rdnum))
                # 受信データ領域から受信データ数分のデータを抽出し、cp932コード文字列に変換
                if rdnum.value != 0:
                    rdata = ((rdatabuf.value)[0:(rdnum.value)]).decode('cp932')
            break                    # 受信待ちループ終了
        tcnt = tcnt + 1              # タイムアウトカウンタ更新
        if tcnt > 105:               # コマンド実行間隔の最大時間
            break                    # タイムアウト
        if rqnum.value > rqnumtmp:   # 受信データ数が増えた(受信途中の)とき
            rqnumtmp = rqnum.value   # 前の受信済み文字数を更新
            tcnt = 0                 # タイムアウトカウンタ リセット
        time.sleep(0.01)             # 待ち時間
    return rdata

# 関数 デバイスのclose
#     引数   : デバイスハンドル
#     戻り値 : 正常終了のとき0

def close_dacs(hdl):
    dll = ctypes.cdll.LoadLibrary('/usr/local/lib/libftd2xx.so')
    res = dll.FT_Close(hdl)
    os.system('sudo modprobe ftdi_sio')         # 仮想COMドライバを登録する
                                                #   デフォルトにもどすため
    return res
