/*****************************************************************************
 *****************************************************************************


 DACS-9600BT-CNT ý۸  D96BTDICNT.CPP    (VC2022)

                                          _bNXZ  2023/10/29

******************************************************************************
*****************************************************************************/

#include <windows.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <thread>
#include "resource.h"
#define   ID_TIMER   1                           // ϰID

int     WINAPI   WinMain        (_In_ HINSTANCE , _In_opt_  HINSTANCE , _In_ LPSTR , _In_ int );
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

int              hextobin(int, char *);
void             Crt_GetDC      (void);
void             Crt_ReleaseDC  (void);

int              Vc_Open        (void);          // COMJ
void             Vc_Close       (void);          // COM
int              Vc_State       (void);          // COMɂMް擾
int              Vc_Read        (int, char *);   // COMM
int              Vc_Write       (int, char *);   // COMɑM

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int    Strh    = 16;                             // 
int    Strw    =  8;                             // 
char  *Strfont = "lr SVbN";                // (޼)"

char   kinbuf[128];                              // ޯ̧
int    kincnt  = 0;                              // ͐

char        serbuf[16];                          // رٔԍ
int         RxTimecount = 0;                     // MѱĶ
int         TxRxOnWait = 0;                      // ʐMJnON҂
int         kincomm = 0;                         // ͺޑMv
int         autocomm = 0;                        // lǎM҂

HANDLE    hRs;                                   // COM 
#define   bRsSize   1024                         // COMޯ̧

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(_In_ HINSTANCE hCurInst, _In_opt_  HINSTANCE hPrevInst, _In_ LPSTR lpCmdLine, _In_ int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);          // ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  HWND   hwnd;                                   // 쐬Ҳݳ޳
  int    l, r;
  char   buf[128];

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd = CreateWindow  (cName,                   // ޳׽       (RegisterClassœo^O)
                        "DACS-9600BT-CNT JE^eXgvO", // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        450,                     //    ̏l     (CW_USEDEFAULT)
                        450,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd = hwnd;                                   // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);
  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  TextOut(hDc, 10, 20,"COM|[g ", 16);
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
  r = Vc_Open();                                 // COMJ
  if(r < 3) r = Vc_Open();                       // ڑłȂꍇAĎs
  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  if (r > 2) {
      l = sprintf_s(buf, 32, "ڑCOM|[gԍ %d ", r);
      TextOut(hDc, 10, 20, buf, l);
      SetTimer(hwnd, ID_TIMER, 100, NULL);       // 100msecϰݒ
  }
  else TextOut(hDc, 10, 20, " ڑ Ȃ      ", 16);
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  char        buf[256], rxbuf[256], txbuf[256];
  int         r, l, cno;
  int         WriteNum, TransNum;
  int         ReadNum, RecNum;

  switch(message)
  {
    case WM_COMMAND:                          // *** ޑ ***
           switch(LOWORD(wParam)){
               case ID_EXIT :
                       DestroyWindow(hwnd);
                       break;                    // ۸яI
               default:
                       return(DefWindowProc(hwnd, message, wParam, lParam));
                       break;
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***
          if(hRs == INVALID_HANDLE_VALUE) break;  // COMJĂƂ̂ݎs
          if(TxRxOnWait < 50) break;             // ʐMJnł܂5b҂

          if(kincomm) break;                     // ͺޑMv̂Ƃ͂ȂɂȂ
          switch(wParam){
               case 0x1b:                        // ESC ̂Ƃر
                   kincnt = 0;
                   break;
               case 0x08:                        // BS ̂Ƃ-1
                   kincnt = kincnt - 1;
                   break;
               case '$':                         // '$'  pass
                   break;
               default :                         // ްi[
                   kinbuf[kincnt] = wParam;
                   kincnt = kincnt + 1;
                   break;
           }
           if(kincnt < 0) kincnt = 0;            // ͐𐧌
           if(kincnt > 32) kincnt = 32;
           kinbuf[kincnt] = '_';                 // وʒu\pLǉ
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           TextOut(hDc,10,60,"  >>                                  ",44);
           TextOut(hDc,100,60,kinbuf,kincnt+1);  // ̓f[^\

           if(wParam == 0xd){                    // Enter ̂Ƃ
               if(kincnt !=0) kincomm = 1;       // ͺޑMvON
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           break;

    case WM_TIMER:                           // *** ݒ莞 ***

           // NA΂炭҂

           if(TxRxOnWait < 50){
               TxRxOnWait++;                     // ʐMJnON҂XV
               if(TxRxOnWait == 50) l = sprintf_s(buf,128,"  >> _              "); // ͎w\
               else                 l = sprintf_s(buf,128,"΂炭҂      ");
               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               TextOut(hDc,10,60,buf,l);
               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )
               break;
           }

           KillTimer(hwnd, ID_TIMER);            // ϰI

           // ѱď

           if(RxTimecount > 500){                // MѱĎԂo

               kincomm = 0;                      // ͺމ҂
               autocomm = 0;                     // lǎ҂

               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               l = sprintf_s(buf,128,"ڑ҂                                         ");
               TextOut(hDc,10,240,buf,l);
               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )

               RxTimecount = 0;                  // ѱĶؾ
           }

           // Mް̎擾

           ReadNum = Vc_State();

           // ͺނɑ΂ްM

           if((ReadNum > 8) && (kincomm > 1)){   // Mςް 9 ȏŁAͺނɑ΂鉞҂̂Ƃ
               if(kincomm == 2) kincomm = 3;     // Ō̎ʕMȂ̂ŁAǎ1TCNɂ
               else{
                   if(ReadNum > 100) ReadNum = 100;
                   RecNum = Vc_Read(ReadNum,rxbuf); // ͂𑗐MƂ̉M
                   Crt_GetDC();                  // DC̏ݒ (,,׼ = )
                   l = RecNum;
                   if(l > 40){
                       l = 40;
                       rxbuf[l-1] = '>';
                   }
                   TextOut(hDc,100,120,rxbuf,l); // Mf[^\
                   Crt_ReleaseDC();              // DC̏Iݒ (,,׼ = )
                   ReadNum = ReadNum - RecNum;   // Mްؾ
                   RxTimecount = 0;              // MѱĶؾ
                   kincomm = 0;                  // ͺމ҂
               }
           }

           // ް̎M

           if((ReadNum > 52) && (autocomm == 1)){ // Mςް53ȏ̂Ƃ

               RecNum = Vc_Read(53,rxbuf);       // *** lްMƂ̏ ***

               if((rxbuf[0] == 'N') && (rxbuf[2] == 'E') && (RecNum == 53)){
                                                 // *** lްMƂ̏ ***
                   Crt_GetDC();                  // DC̏ݒ (,,׼ = )
                   for(cno = 0; cno != 6; cno++){
                       if(cno < 3) l = sprintf_s(buf," %1d >>               ",cno);
                       else        l = sprintf_s(buf,"ΰ%1d >>               ",cno-3);
                       TextOut(hDc,10,240+15*cno,buf,l);
                       TextOut(hDc,100,240+15*cno,&rxbuf[4+cno*8],8);   // l\
                       r = hextobin(8, &rxbuf[4+cno*8]);                // 16i𐮐lɕϊ
                       l = sprintf_s(buf," %12d ",r);
                       TextOut(hDc,170,240+15*cno,buf,l);               // l10i\
                   }
                   if(RxTimecount > 50)          // MɎԂƂA΂炭҂
                          std::this_thread::sleep_for(std::chrono::milliseconds(1000));
                   RxTimecount = 0;              // MѱĶؾ
                   Crt_ReleaseDC();              // DC̏Iݒ (,,׼ = )
               }
               ReadNum = ReadNum - RecNum;       // Mްؾ
               if(ReadNum == 0) autocomm = 0;    // lǎ҂
           }

           // ް̑M

           if((kincomm == 1) && (autocomm == 0)){  // ް𑗐M
               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               TextOut(hDc,10,60,"  >> _                            ",40); // \̈ر
               TextOut(hDc,10,90,"M    >>                              ",40);
               l = sprintf_s(buf,128,"M    >>                                         ");
               TextOut(hDc,10,120,buf,l);
               WriteNum = kincnt;

               TransNum = Vc_Write(WriteNum,kinbuf);  // ް𑗐M

               if(TransNum > 0){
                   kincnt = TransNum;
                   TextOut(hDc,100,90,kinbuf,kincnt); // Mf[^\
               }
               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )
               RxTimecount = 0;                  // MѱĶݒ
               if((kinbuf[1] == '4') || (kinbuf[1] == 'C') || (kinbuf[1] == 'c')) kincomm = 0;
                                                 // vȂ̂ƂAͺޑMvؾ
               else kincomm = 2;                 // v̂ƂAͺނɑ΂鉞҂Ƃ
               kincnt = 0;                       // ްؾ 
           }

           // ްMނ̎M

           if((autocomm == 0) && (kincomm == 0)){
               // *** Mނlǎ̂߂ɑM ***
               l = sprintf_s(txbuf,128,"M0E ");  // MR}h(ׂĂ̶lꊇǎ)
               txbuf[3] = 0xd;                   // CR޾
               WriteNum = 4;                     // ް
               
               TransNum = Vc_Write(WriteNum,txbuf);  // ް𑗐M

               RxTimecount = 0;                  // MѱĶؾ
               kincomm = 0;                      // ͺމ҂
               autocomm = 1;                     // lǎ҂Ƃ
           }

           SetTimer(hwnd, ID_TIMER, 10, NULL);   // 10msecϰݒ
           if(RxTimecount < 10000) RxTimecount++;  // MѱĶXV
           break;

    case WM_DESTROY:                         // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI
           Vc_Close();                           // COM
           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           return(DefWindowProc(hwnd, message, wParam, lParam));
           break;
  }

  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : int Vc_Open(void)
   Ұ : Ȃ
      : COMJ
   ߂l : -1 : = ُ   3`49 =  COMԍ
******************************************************************************/

int Vc_Open(void)
{
  DCB          dcb;
  COMMTIMEOUTS timeouts;
  int          comnum, r;
  int          ret = -1;
  char         buf[256];

  timeouts.ReadIntervalTimeout         = 100;   // Vc_Read ֐炷߂悤ɐݒ肷
  timeouts.ReadTotalTimeoutMultiplier  = 100;
  timeouts.ReadTotalTimeoutConstant    = 1000;
  timeouts.WriteTotalTimeoutMultiplier = 100;
  timeouts.WriteTotalTimeoutConstant   = 1000;

  for(comnum = 3; comnum != 50; comnum++) { // COM 3`49܂Ō
      sprintf_s(buf, 20, "\\\\.\\COM%1d", comnum);
      hRs = CreateFile(buf,                 // ߰ COM3`49
              GENERIC_READ | GENERIC_WRITE, // ǂݏӰ
              0,                            // ̧ق̋LȂ
              NULL,                         // èȂ
              OPEN_EXISTING,                // ِ̧@
              FILE_ATTRIBUTE_NORMAL,        // ̧ق̑ޯĂ̐ݒl
              NULL);                        // gȂ
      if(hRs != INVALID_HANDLE_VALUE){
          if (SetupComm(hRs, bRsSize, bRsSize) != FALSE) {  // ޯ̧ނݒ肷
              if ((GetCommState(hRs, &dcb)) != FALSE) {     // ʐM߰Ă̶ďԎ擾
                  dcb.BaudRate = CBR_115200;                // ްڰ
                  dcb.ByteSize = 8;                         // ޯĐ    4`8
                  dcb.Parity = 0;                           // è@   0`4=Ȃ,,,ϰ,߰
                  dcb.StopBits = 0;                         // įޯ 0`2=1,1.5,2
                  if (SetCommState(hRs, &dcb) != FALSE) {   // ʐM߰Ă̶ďԐݒ
                      if (SetCommTimeouts(hRs, &timeouts) != FALSE) {      // ѱĒlݒ
                          PurgeComm(hRs, PURGE_RXCLEAR | PURGE_TXCLEAR);   // oޯ̧ر
                          sprintf_s(buf, 20, "W0 ");        // ڑmFp Wޏ
                          buf[2] = 0xd;
                          if(Vc_Write(3,buf) == 3){         // ްM
                              std::this_thread::sleep_for(std::chrono::milliseconds(1000)); // ҂
                              buf[0] = 0;
                              r = Vc_Read(128,buf);         // COMM
                              if(r > 8){
                                  if((buf[r-1] == 0xd) && (buf[r-9] == 'R')){   // Rڽݽ ΑΏۃfoCX
                                      ret = comnum;         // ڑCOM߰Ĕԍ
                                      break;                // I
                                  }
                              }
                          }
                      }
                  }
              }
          }
          CloseHandle(hRs);                 // ڑłȂCOM߰Ă
      }
  }
  return(ret);
}

/******************************************************************************
   ֐   : void Vc_Close(void)
   Ұ : Ȃ
      : COM
   ߂l : Ȃ
******************************************************************************/

void Vc_Close(void)
{
  if(hRs != INVALID_HANDLE_VALUE) CloseHandle(hRs);
}

/******************************************************************************
   ֐   : int Vc_Read(int num,char *str)
   Ұ : num    őMް(byte)
            *str   Mް(߂l̎Mް̂ݗL)
      : COMM
   ߂l : -1 = ُ    0` = (Mް byte)
******************************************************************************/

int Vc_Read(int num, char *str)
{
  char  buf[256];
  DWORD rnum;
  DWORD cnt = 0;
  int   ret = -1, tout = 0, rdno, r, p = 0;

  if(hRs != INVALID_HANDLE_VALUE){            // COMJĂ?
      rnum = (DWORD)num;
      do{
          if(rnum > 252) rnum = 252;
          if((p+(int)rnum) > num) rnum = (DWORD)(num - p);  // Ǎݐwްɐ
          if(ReadFile(hRs,buf,rnum,&cnt,0) == FALSE) return(-1);  // ްM
          else{                               // 
              rdno = (int)cnt;                // Mް
              if(rdno != 0){
                  for(r = 0; r != rdno; r++) str[p++] = buf[r]; // Mް̺߰
                  if(str[p-1] == 0xd) break;  // Mf[^CR̂ƂI
              }
          }
          if((p == 0) || (p >= num)) break;   // SްȂA܂͎wްǍݍς݂̂ƂI
          tout++;                             // ѱĶ{1
          std::this_thread::sleep_for(std::chrono::milliseconds(10)); // ҂
      }while(tout < 6);
      ret = p;                                // Mް߂l
  }
  return(ret);
}

/******************************************************************************
   ֐   : int Vc_State(void)
   Ұ : Ȃ
      : COMɂMް擾
   ߂l : 0` = Mް byte

******************************************************************************/

int Vc_State(void)
{
  DWORD   dwErrors;
  COMSTAT ComStat;
  int     Count = 0;

  if(hRs != INVALID_HANDLE_VALUE){            // COMJĂ?
      ClearCommError(hRs, &dwErrors, &ComStat);
      Count = (int)ComStat.cbInQue;
  }
  return(Count);
}

/******************************************************************************
   ֐   : int Vc_Write(int num,char *str)
   Ұ : num    Mް(byte)
            *str   Mް
      : COMɑM
   ߂l : -1 = ُ    0` = Młް byte
******************************************************************************/

int Vc_Write(int num, char *str)
{
  DWORD        snum;
  DWORD        cnt = 0;
  int          ret = -1;

  if(hRs != INVALID_HANDLE_VALUE){            // COMJĂ?
      snum = (DWORD)num;
      if(WriteFile(hRs,str,snum,&cnt,0) != FALSE){ // ްM
          if(cnt == snum) ret = cnt;          // Młް
      }
  }
  return(ret);
}

/******************************************************************************
   ֐   : int hextobin(int num,char *buf)
   Ұ : num HEXް
            *str HEXް  
      : HEXintɕϊ
   ߂l : ϊbinaryް   ُ̂Ƃ-1
******************************************************************************/

int hextobin(int num, char *buf)
{
    char  datatmp;
    int   cnt, tmp;
    int   ret = 0;

    if(num < 1) return(-1);
    for(cnt = 0; cnt != num; cnt++){
        datatmp = buf[cnt];
        tmp = -1;
        if((datatmp > 0x2f) && (datatmp < 0x3a)) tmp = datatmp - 0x30;
        if((datatmp > 0x40) && (datatmp < 0x47)) tmp = datatmp - 0x41 + 10;
        if(tmp == -1) return(-1);
        else          ret = ret*16 + tmp; 
    }
    return(ret);
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}

/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
