# DACS-9600KWF-CNT カウンタ サンプルプログラム

# Windows10(64bit) 、Python 3 にて動作
# デバイスがネットワークに接続済とします。
# IPアドレスはデバイスの設定に一致させてください。
#     文字列 d96WFIPaddd = '192.168.0.42' 行の
#     '192.168.0.42' をデバイスのIPアドレスに変更

# d96wfcnt.py を起動すると

# カウント開始コマンドを自動送信します。
# カウンタ値読取りコマンドを自動送信し、
#     カウンタ値を読取って連続表示します。
# 0～2番のカウンタ値と各ホールド値を表示します。

# W0000000(enter)などのコマンド文字列入力にて
#    デバイスを操作することができます。
#    例: M018(enter) と入力すると
#    カウンタ0番がエンコーダモードになります。
# 表示を一時停止するときはスペースキーなどを押す
#    enter にて表示再開

# enter のみをキー入力するとプログラムが終了します。

import socket
import msvcrt
import time

# 関数 データ送信と応答受信
#     引数1 : ソケットオブジェクト
#     引数2 : 送信データ
#     引数3 : 最少受信文字数(0のときはリトライなし)
#     戻り値 : 受信データ

def transfer_D96KWF(d96WF, wdata, rnum):

    # 送信する文字列をASCII文字列に変換
    wdatabuf = wdata.encode('ascii')

    # データ送信
    d96WF.sendall(wdatabuf)

    # データ受信
    if rnum == 0:               # 文字数が無指定のときのみ
        time.sleep(0.5)         #     受信待ち
    rdata =''                   # 受信データを初期化
    for cnt in range(60):       # タイムアウトまで繰返す
        time.sleep(0.05)        # 受信待ち
        try:
            # データ受信
            rdatabuf = d96WF.recv(1024)

            # ASCII文字列をcp932文字列に変換
            rdata = rdata + rdatabuf.decode('cp932')
            if len(rdata) >= rnum:
                break
        except:
            if rnum == 0:       # 文字数が無指定のときのみ
                break           #     リトライしない
    return rdata

# ここから実行開始

# TCP/IP ソケットオブジェクトの作成
d96 = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

# タイムアウト設定 単位:秒(接続呼出しから戻る最大時間)
d96.settimeout(3)

# DACS-9600KWF に接続開始

# ******** 重要 ********
#   IPアドレスはデバイスの設定に一致させてください
# **********************
d96wfIPadd = '192.168.0.42'

try:
    d96.connect((d96wfIPadd, 0x2616))
except:
    print('connection error')
    time.sleep(2)           # メッセージ表示時間
    exit()                  # 接続できないときは終了

time.sleep(1)               # 送受信開始まで少し待つ

# カウント開始を送信
writedata = 'M008&M028&M048' + chr(0xd)
readdata = transfer_D96KWF(d96, writedata, 0)

if len(readdata) != 27:     # (9文字)X(3コマンド)=27
    print('time-out error') # タイムアウトエラー
    d96.close()             # 接続終了
    time.sleep(2)           # メッセージ表示時間
    exit()                  # 応答がないときは終了

# カウンタ値の送信要求コマンド文字列を準備
ccommand = 'M0E' + chr(0xd)

disp1 = '|    ch0    |    ch1    |    ch2    |    hd0    |    hd1    |    hd2    |'
print(disp1)                # カウンタ番号表示

# ここからはブロッキング時間を短くする
# タイムアウト設定 単位:秒(送信、受信呼出しから戻る最大時間)
d96.settimeout(0.1)

# カウンタ値の取得と画面表示を繰返す
while True:
    # 3chカウンタ値と3chホールド値を取得
    readdata = transfer_D96KWF(d96, ccommand, 53)

    if len(readdata) != 53 or readdata[0:1] != 'N':
        # M0E コマンドの応答は53文字
        # エラーのとき、コマンドを送信し、残留データを読み切る

        readdata = transfer_D96KWF(d96, 'W0'+chr(0xd), 128)
        # 受信文字数は128より少ないので、タイムアウトで戻る

        if len(readdata) < 9: # それでも応答がないとき
            print("")
            print('time-out error')
            break;          # ループを終了
        else:
            continue;       # 応答があればループを継続

    # 正常にデータを受信したとき
    sdata = ''              # 画面表示用の文字列を初期化
    for cnt in range(6):
        p = cnt*8 + 4       # カウンタ値文字列中の位置

        # 16進数8桁文字列を10進数の整数に変換
        try:
            cdata = int(readdata[(p):(p+8)],16)
        except ValueError:
            break

        # 32bit長の負数処理
        if cdata > 0x7fffffff:
            cdata = cdata - 0x100000000

        # 画面表示用に12桁の文字列で連結する
        sdata = sdata + ("{:12d}".format(cdata))

    # カウンタ値を画面表示
    if len(sdata) == 72:    # 正常データのとき
        print(sdata,end='\r')
    else:                   # 不正データのとき
        print('data error'+' '*62)
        time.sleep(3)

    # キー入力があったときの処理
    if msvcrt.kbhit():
        print('')

        # キー入力文字にCRコードを付加
        kydata = input() + chr(0xd)

        # enterのみのときは終了
        if kydata[0:1] == chr(0xd):
            print('end')
            break

        # キー入力データを送信し応答を受信
        elif len(kydata) > 2:
            readdata = transfer_D96KWF(d96, kydata, 2)
            print(readdata) # 応答を画面表示

        print(disp1)        # カウンタ番号表示

# 接続終了
d96.close()
time.sleep(2)    # メッセージ表示時間
