/*****************************************************************************
 *****************************************************************************


 DACS-E350 ʐMý۸ <USB> DAE350TTY.CPP

                                          _bNXZ  2016/06/23

   1 DACS-E350-STD̓dɖ{vONƂ
           E350LinuxNfɑΉ邽߁A
           reset R}h𑗐ME350ċN鏈ǉ   2018/09/10
   2 N̏(E350bootɋNƂ̑Ώ)
         N LinuxbZ[W random: nonblocking --ǔ΂2019/03/25

******************************************************************************
*****************************************************************************/

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include "resource.h"
#include "Ftd2xx.h"                              // ޲ڸĔײޗp̧ͯقǉ
#define   ID_TIMER 1                             // ϰID

int     WINAPI   WinMain        (HINSTANCE ,HINSTANCE ,LPSTR ,int );
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

int              DAE350open(void);               // DACS-E350-STD OPEN
void             DAE350close(void);              // DACS-E350-STD CLOSE
int              hextobin(int, char *);          // 16i޲؂ɕϊ
void             Crt_GetDC      (void);          // DC̏ݒ
void             Crt_ReleaseDC  (void);          // DC̏Iݒ

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int    Strh    = 16;                             // 
int    Strw    =  8;                             // 
char  *Strfont = "lr SVbN";                // (޼)

char   kinbuf[256];                              // ޯ̧
int    kincnt  = 0;                              // ͐

int    startcntr = 0;                            // ǎJn׸(ѱĶɂgp)
char   mcombuf[256];                             // MޑMް
int    startpmmr = 0;                            // Ӱ݈ړʓǎJn׸(ѱĶɂgp)
char   pmcombuf[256];                            // QޑMް
int    startpmpr = 0;                            // Ӱ݈ʒuǎJn׸(ѱĶɂgp)
char   ppcombuf[256];                            // qޑMް

int    cntrmax = 0;                              // MԊu\p MԊuől
int    newcnttime = 0;                           //                  ǎJn(V)
int    oldcnttime = 0;                           //                  ǎJn()
int    pmmrmax = 0;                              // MԊu\p ړʎMԊuől
int    newpmmtime = 0;                           //                  ړʓǎJn(V)
int    oldpmmtime = 0;                           //                  ړʓǎJn()
int    pmprmax = 0;                              // MԊu\p ʒuMԊuől
int    newpmptime = 0;                           //                  ʒuǎJn(V)
int    oldpmptime = 0;                           //                  ʒuǎJn()
int    cyclecnt = 0;                             // \pٶ

int    adccount = 0;                             // \pADCݸ޶

FT_HANDLE   ftHandle;                            // FT޲
FT_STATUS   ftStatus;                            // FTð
DWORD       numDevs;                             // ޲(۸тł1݂̂Ƃ)

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);          // ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  int    r, s;
  HWND   hwnd;                                   // 쐬Ҳݳ޳
  char   txtbuf[1024];

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd = CreateWindow  (cName,                   // ޳׽       (RegisterClassœo^O)
                        "c`br|dRTO traʐMeXg TvvO", // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        760,                     //    ̏l     (CW_USEDEFAULT)
                        580,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd = hwnd;                                   // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);

  sprintf_s(mcombuf,128,"M00 M01 M02 M03 M04 M05 M08 M09 M0A M0B M0C M0D ");  // MޑMް쐬
  for(r = 0; r != 12; r++) mcombuf[3+r*4] = 0xd;
  sprintf_s(pmcombuf,128,"Q00 Q01 Q02 Q03 Q04 Q05 Q06 Q07 ");  // QޑMް쐬
  for(r = 0; r != 8; r++) pmcombuf[3+r*4] = 0xd;
  sprintf_s(ppcombuf,128,"q00 q01 q02 q03 q04 q05 q06 q07 ");  // qޑMް쐬
  for(r = 0; r != 8; r++) ppcombuf[3+r*4] = 0xd;

  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  TextOut(hDc,10,20,"N ΂炭҂B      ",37);
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )

  s = DAE350open();                              // DACS-E350 OPENB DACS-E350̃f[^]vON
  if(s == -2){                                   // DACS-E350-STDbootJnĂȂNُ̂Ƃ
      Sleep(6000);                               // DACS-E350-STDbootJn܂ő҂
      s = DAE350open();                          // ēxADACS-E350 OPENB DACS-E350̃f[^]vON
  }

  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  if(s == 0){                                    // ɋNłƂ
      sprintf_s(txtbuf,128,"M   >>                                  ");
      TextOut(hDc,10,50,txtbuf,strlen(txtbuf));
      sprintf_s(txtbuf,128,"M   >>                                  ");
      TextOut(hDc,10,80,txtbuf,strlen(txtbuf));
      sprintf_s(txtbuf,128," >>                                                     ");
  }
  else{                                          // DACS-E350ɋNłȂƂ
      sprintf_s(txtbuf,128,"DACS-E350̓dƐڑmFAvOċNĂ ");
  }
  TextOut(hDc,10,20,txtbuf,strlen(txtbuf));      // үނ\
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
  SetTimer(hwnd, ID_TIMER, 100, NULL);           // 100msecϰݒ

  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  PAINTSTRUCT ps;
  char        buf[1024], recbuf[1024], txtbuf[1024];
  int         r, p, q, s, t, u;
  DWORD       WriteNum, TransNum;
  DWORD       ReadNum, RecNum, EventDword;

  switch(message)
  {
    case WM_COMMAND:                          // *** ޑ ***
           switch(LOWORD(wParam)){
             case ID_EXIT : DestroyWindow(hwnd); break;  // ۸яI
             default      : return(DefWindowProc(hwnd, message, wParam, lParam));
                            break;
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           switch(wParam){
               case 0x1b:                        // ESC ̂Ƃر
                   kincnt = 0;
                   break;
               case 0x08:                        // BS ̂Ƃ-1
                   kincnt = kincnt - 1;
                   break;
               default :                         // ްi[
                   kinbuf[kincnt] = wParam;
                   kincnt = kincnt + 1;
                   break;
           }
           if(kincnt < 0) kincnt = 0;            // ͐𐧌
           if(kincnt > 32) kincnt = 32;
           kinbuf[kincnt] = '_';                 // وʒu\pLǉ
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           TextOut(hDc,10,20," >>                                  ",43);
           TextOut(hDc,100,20,kinbuf,kincnt+1);  // ̓f[^\

           if(wParam == 0xd){                    // Enter ̂Ƃ
               if(kincnt !=0){
                   sprintf_s(buf,128," >>                                  "); // \̈ر
                   TextOut(hDc,10,20,buf,strlen(buf));
                   sprintf_s(buf,128,"M   >>                                  ");
                   TextOut(hDc,10,50,buf,strlen(buf));
                   sprintf_s(buf,128,"M   >>                                  ");
                   TextOut(hDc,10,80,buf,strlen(buf));

                   TransNum = 0;
                   WriteNum = kincnt;            // Mް
                   ftStatus = FT_Write(ftHandle,kinbuf,WriteNum,&TransNum);
                                                 // kinbufɂްWriteNum ɂĎwM
                   if(TransNum > 0){
                       kincnt = TransNum;
                       for(r = 0; r != kincnt; r++){
                           if(kinbuf[r] == 0xd) kinbuf[r] = '.';  // CRDɕςĕ\
                       }
                       TextOut(hDc,100,50,kinbuf,kincnt);  // Mް\
                   }
                   if((kinbuf[0] == 'S') && (kinbuf[2] >= '0') && (kinbuf[2] < '9')){
                       for(r = 0; r != 4; r++){  // ADϊJn̂ƂADϊް\
                           t = 20+r*20;
                           TextOut(hDc,420,t,"                                    ",36);
                       }
                       TextOut(hDc,420,100,"                  ",18);
                       adccount = 0;             // \pADCݸ޶ؾ
                   }
               }
               kincnt = 0;
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           SetTimer(hwnd, ID_TIMER, 20, NULL);   // 20msecϰݒ
           break;

    case WM_TIMER:                           // *** ݒ莞 ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           ReadNum = 0;
           FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);  // ReadNum ɎMςް擾

           Crt_GetDC();                          // DC̏ݒ (,,׼ = )

           while(ReadNum >= 12){                 // Mςް 12 ȏ̂Ƃ

               ftStatus = FT_Read(ftHandle,recbuf,12,&RecNum); // recbufɤReadNum ɂĎw肵ްǎ

               ReadNum = ReadNum - RecNum;
               if((recbuf[11] != 0xd) || (recbuf[1] != '0')){  // IDԍCRނ

                   // **** sްMƂ̏ ****

                   // *************************************************
                   //       random: nonblocking pool is initialized үނ
                   //      DACS-E350-STD d1ȓɏo͂̂폜鏈܂߂ĂB
                   //      ȕ̓rɁAүނ邱Ƃ̂ŁAGȏƂȂĂB
                   //      () sްƂĈꊇ폜AMѱĂɂčĊJPȂ̂ŁA
                   //           25s̺ĂƂĂ镔̕@߂łB
                   // *************************************************

                   for(r = 0; r != 256; r++){                  // sް̂ƂA0xa ݂܂Ŏcf[^ǐ؂
                       if(recbuf[11+r] == 0xa) break;
                       if(ReadNum <= 0){
                           Sleep(10);
                           FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);  // ReadNum ɎMςް擾
                       }
                       if(ReadNum <= 0) break;
                       ftStatus = FT_Read(ftHandle,&recbuf[12+r],1,&RecNum);       // 1Âcf[^ǎ
                       ReadNum--;
                   }
                   p = 12 + r;                   // Mް̍vZo
                   p = p - 41;                   // bZ[W random: nonblocking pool is initialized CRLF܂߂č폜
                   if(p <= 0) break;
                   r = ReadNum;
                   if(r < (12-p)) break;
                   ReadNum = 12-p;               // 12ɕs镶M
                   ftStatus = FT_Read(ftHandle,&recbuf[p],ReadNum,&RecNum);        // cf[^ǎČ

                   if((recbuf[11] != 0xd) || (recbuf[1] != '0')) break;            // IDԍCRނ
                                                 // 񂪐ްƂȂꍇ́Aȉ̏ɈڍsB
                                                 // ްAȂsް̏ꍇ́AްjB

                   // *************************************************
                   //      sްƂĈꊇ폜AMѱĂɂčĊJP
                   //      ̕@߂܂
                   // *************************************************

                   //Sleep(10);
                   //FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);                 // ReadNum ɎMςް擾
                   //if(ReadNum > 0) ftStatus = FT_Read(ftHandle,recbuf,ReadNum,&RecNum);   // sf[^̂Ƃcf[^ǐ؂
                   //break;

               }

               // **** lǎ ****

               if(recbuf[0] == 'N'){                           // N̂Ƃ
                   r = int(recbuf[2] - 0x30);                  // ԍ擾
                   if(r > 9) r = r-7;                          // A`F̏
                   p = hextobin(8,&recbuf[3]);                 // MĒl𐮐ɕϊ
                   sprintf_s(buf,128,"%12d", p);
                   if(r == 0){
                       sprintf_s(txtbuf,128," ");          // ٕ\
                       TextOut(hDc,10,130,txtbuf,strlen(txtbuf));
                   }
                   if(r == 8){
                       sprintf_s(txtbuf,128,"ΰ ");         // ΰٕ\
                       TextOut(hDc,10,300,txtbuf,strlen(txtbuf));
                   }
                   if(r < 8){                                  // Ēlް̂Ƃ
                       sprintf_s(txtbuf,128,"%1d ", r);        // ԍ\
                       TextOut(hDc,70,130+r*20,txtbuf,2); 
                       TextOut(hDc,100,130+r*20,&recbuf[3],8); // Ēl 16i\
                       TextOut(hDc,220,130+r*20,buf,12);       // Ēl 10i\
                   }
                   else{                                       // ΰޒlް̂Ƃ
                       sprintf_s(txtbuf,128,"%1d ", r-8);      // ԍ\
                       TextOut(hDc,70,140+r*20,txtbuf,2);
                       TextOut(hDc,100,140+r*20,&recbuf[3],8); // ΰޒl 16i\
                       TextOut(hDc,220,140+r*20,buf,12);       // ΰޒl 10i\
                   }
                   if((r == 13) || (startcntr == 0)){          // ŌްMƂA܂͕\Jn̂Ƃ
                       WriteNum = 48;
                       TransNum = 0;
                       ftStatus = FT_Write(ftHandle,mcombuf,WriteNum,&TransNum);   // M(6)M

                       if(startcntr == 0) newcnttime = clock(); // vԊu\p ŏ̐VJn
                       startcntr = 1;                          // ǎJnςƂ
                       oldcnttime = newcnttime;                // vԊu\p Jn
                       newcnttime = clock();                   // vԊu\p VJn
                   }
                   continue;
               }

               // **** Ӱݺ۰׈ړʓǎ ****

               if(recbuf[0] == 'S'){                           // ŜƂ
                   r = int(recbuf[2] - 0x30);                  // Ӱݎԍ擾
                   if(r > 9)  r = r-7;                         // A`F̏
                   q = 0;                                      // ܂͒~Ƃ
                   if(r >= 8){
                       r = r-8;                                // ړR[h̏
                       q = 1;                                  // ړƂ
                   }
                   if(r == 0){
                       sprintf_s(txtbuf,128,"ړ ");        // ړٕ\
                       TextOut(hDc,360,130,txtbuf,strlen(txtbuf));
                   }
                   if(r == 6){
                       sprintf_s(txtbuf,128,"ϰ ");          // ϰٕ\
                       TextOut(hDc,360,250,txtbuf,strlen(txtbuf));
                   }
                   p = hextobin(8,&recbuf[3]);                 // Mړʂ𐮐ɕϊ
                   sprintf_s(buf,128,"%12d", p);
                   if(q == 0) sprintf_s(txtbuf,128,"%1d ", r);                 // ~ϰ
                   else{
                       if((p < 0) || (r > 5)) sprintf_s(txtbuf,128,"%1d ", r); // ړϰ
                       else      sprintf_s(txtbuf,128,"%1d ", r);              // ړϰ܂ͶĒϰ
                   }
                   TextOut(hDc,420,130+r*20,txtbuf,4);         // ԍ(ԍ)ƈړϰ\
                   TextOut(hDc,460,130+r*20,&recbuf[3],8);     // ړ 16i\
                   TextOut(hDc,600,130+r*20,buf,12);           // ړ 10i\
                   if((r == 7) || (startpmmr == 0)){           // ŌްMƂA܂͕\Jn̂Ƃ
                       WriteNum = 32;
                       TransNum = 0;
                       ftStatus = FT_Write(ftHandle,pmcombuf,WriteNum,&TransNum);   // QގM

                       if(startpmmr == 0) newpmmtime = clock(); // vԊu\p ŏ̐VJn
                       startpmmr = 1;                          // [VړʓǎJnςƂ
                       oldpmmtime = newpmmtime;                // vԊu\p Jn
                       newpmmtime = clock();                   // vԊu\p VJn
                   }
                   continue;
               }

               // **** Ӱݺ۰׈ʒuǎ ****

               if(recbuf[0] == 's'){                           // ŝƂ
                   r = int(recbuf[2] - 0x30);                  // Ӱݎԍ擾
                   if(r > 9)  r = r-7;                         // A`F̏
                   if(r >= 8) r = r-8;                         // ړR[h̏
                   if(r == 0){
                       sprintf_s(txtbuf,128,"ʒu ");          // ʒuٕ\
                       TextOut(hDc,360,300,txtbuf,strlen(txtbuf));
                   }
                   if(r == 6){
                       sprintf_s(txtbuf,128,"ðA ");        // ðAٕ\
                       TextOut(hDc,360,420,txtbuf,strlen(txtbuf));
                   }
                   if(r == 7){
                       sprintf_s(txtbuf,128,"ðB ");        // ðBٕ\
                       TextOut(hDc,360,440,txtbuf,strlen(txtbuf));
                   }
                   sprintf_s(txtbuf,128,"%1d ", r);            // ԍ\
                   TextOut(hDc,420,300+r*20,txtbuf,2);
                   TextOut(hDc,460,300+r*20,&recbuf[3],8);     // ʒu 16i\
                   if(r < 6){
                       p = hextobin(8,&recbuf[3]);             // Mʒu𐮐ɕϊ
                       sprintf_s(buf,128,"%12d", p);
                       TextOut(hDc,600,300+r*20,buf,12);       // ʒu 10i\
                   }
                   if((r == 7) || (startpmpr == 0)){           // ŌްMƂA܂͕\Jn̂Ƃ
                       WriteNum = 32;
                       TransNum = 0;
                       ftStatus = FT_Write(ftHandle,ppcombuf,WriteNum,&TransNum);   // qގM

                       if(startpmpr == 0) newpmptime = clock(); // vԊu\p ŏ̐VJn
                       startpmpr = 1;                          // [VʒuǎJnςƂ
                       oldpmptime = newpmptime;                // vԊu\p Jn
                       newpmptime = clock();                   // vԊu\p VJn
                   }
                   continue;
               }

               // **** ADϊlǎ ****

               if((recbuf[0] == 'V')|| (recbuf[0] == 'v')){    // V(ݸٴޓ)܂v()̂Ƃ
                   r = int(recbuf[2] - 0x30);                  // ADC `lԍ擾
                   if(r > 9) r = r -7;                         // A`F̏
                   TextOut(hDc,400,20,"ch",2);
                   if(r & 8){                          // **** `lXV̂Ƃ ****
                       if((r & 1) == 0){                       // ٔԍŝƂ(ݸފԊuZꍇɐ)
                           sprintf_s(txtbuf,128,"َXVُ ");  // ٔԍُ\
                           TextOut(hDc,420,100,txtbuf,strlen(txtbuf));
                           Crt_ReleaseDC();                    // DC̏Iݒ (,,׼ = )
                           continue;             
                       }
                       p = ((r & 3) - 1) * 2;                  // ٔԍ(ي/bitϽ)
                       q = (r & 4) >> 2;                       // ݸٴޓ͂̊ق̂Ƃ 1 ƂȂ
                       s = q * 160;
                       t = p * 10;
                       sprintf_s(txtbuf,128,"%1d ", p+q);      // +0ٔԍ\
                       TextOut(hDc,420+s,20+t,txtbuf,2);
                       TextOut(hDc,440+s,20+t,&recbuf[3],3);   // +0قADް 16i\
                       u = hextobin(3,&recbuf[3]);             // MADް𐮐ɕϊ
                       if((recbuf[0] == 'v') && (u > 2047)) u = u - 4096; // ͂̂Ƃ
                       sprintf_s(buf,128,"%5d mV", u);         // +0قADް 10i\
                       TextOut(hDc,480+s,20+t,buf,8);
                       sprintf_s(txtbuf,128,"%1d ", p+2+q);    // +2ٔԍ\
                       TextOut(hDc,420+s,40+t,txtbuf,2);
                       TextOut(hDc,440+s,40+t,&recbuf[7],3);   // +2قADް 16i\
                       u = hextobin(3,&recbuf[7]);             // MADް𐮐ɕϊ
                       if((recbuf[0] == 'v') && (u > 2047)) u = u - 4096; // ͂̂Ƃ
                       sprintf_s(buf,128,"%5d mV", u);         // +2قADް 10i\
                       TextOut(hDc,480+s,40+t,buf,8);
                   }
                   else{                               // **** Œ`l̂Ƃ ****
                       p = (r & 3) * 2;                        // ٔԍ(ي^bitϽ)
                       q = (r & 4) >> 2;                       // ݸٴޓ͂̊ق̂Ƃ 1 ƂȂ
                       t = p * 10;
                       sprintf_s(txtbuf,128,"%1d ", p+q);      // ٔԍ\(1ްp)
                       TextOut(hDc,420,20,txtbuf,2);
                       TextOut(hDc,440,20,&recbuf[3],3);       // 1ADް 16i\
                       u = hextobin(3,&recbuf[3]);             // MADް𐮐ɕϊ
                       if((recbuf[0] == 'v') && (u > 2047)) u = u - 4096; // ͂̂Ƃ
                       sprintf_s(buf,128,"%5d mV", u);         // 1ADް 10i\
                       TextOut(hDc,480,20,buf,8);
                       sprintf_s(txtbuf,128,"%1d ", p+q);      // ٔԍ\(2ްp)
                       TextOut(hDc,580,20,txtbuf,2);
                       TextOut(hDc,600,20,&recbuf[7],3);       // 2ADް\
                       u = hextobin(3,&recbuf[7]);             // MADް𐮐ɕϊ
                       if((recbuf[0] == 'v') && (u > 2047)) u = u - 4096; // ͂̂Ƃ
                       sprintf_s(buf,128,"%5d mV", u);         // 2ADް 10i\
                       TextOut(hDc,640,20,buf,8);
                   }
                   adccount = adccount + 1;                    // \pADCݸ޶XV
                   if(adccount > 1000000) adccount = 1000000;
                   sprintf_s(txtbuf,128,"ADC No.%8d ", adccount);  // ADCݸ޶\*
                   TextOut(hDc,580,100,txtbuf,strlen(txtbuf));

                   continue;
               }

               // **** ̑̎Mް\ ****

               sprintf_s(buf,128,"M   >>                                  ");
               TextOut(hDc,10,80,buf,strlen(buf));
               p = RecNum;
               for(r = 0; r != p; r++){          // \̂CRނصނɒu
                   if(recbuf[r] == 0xd) recbuf[r] = '.';
               }
               TextOut(hDc,100,80,recbuf,p);     // Mf[^\
           }

           // **** MѱĊĎް]װ̏ ****

           if(startcntr){
               startcntr = startcntr + 1;        // ǎѱĶXV
               r = newcnttime - oldcnttime;      // ԊuZo
               if(r > cntrmax) cntrmax = r;      // ől
               if(cyclecnt == 4){
                   sprintf_s(buf,128,"MԊu%4dms MAX%4dms", r, cntrmax);
                   TextOut(hDc,10,480,buf,strlen(buf));
               }
           }
           if(startpmmr){
               startpmmr = startpmmr + 1;        // Ӱ݈ړʓǎѱĶXV
               r = newpmmtime - oldpmmtime;      // ԊuZo
               if(r > pmmrmax) pmmrmax = r;      // ől
               if(cyclecnt == 8){
                   sprintf_s(buf,128,"ړʑMԊu%4dms MAX%4dms", r, pmmrmax);
                   TextOut(hDc,253,480,buf,strlen(buf));
               }
           }
           if(startpmpr){
               startpmpr = startpmpr + 1;        // Ӱ݈ʒuǎѱĶXV
               r = newpmptime - oldpmptime;      // ԊuZo
               if(r > pmprmax) pmprmax = r;      // ől
               if(cyclecnt == 12){
                   sprintf_s(buf,128,"ʒuMԊu%4dms MAX%4dms", r, pmprmax);
                   TextOut(hDc,510,480,buf,strlen(buf));
               }
           }
           cyclecnt = cyclecnt + 1;              // \pٶXV
           if(cyclecnt > 16) cyclecnt = 0;


           if(startcntr > 100){                  // ǎJnςŶlMȂװ
               startcntr = 1;
               WriteNum = 48;
               TransNum = 0;
               ftStatus = FT_Write(ftHandle,mcombuf,WriteNum,&TransNum);   // M(6)đM
           }
           if(startpmmr > 100){                  // Ӱ݈ړʓǎJnςӰݺ۰׈ړʎMȂװ
               startpmmr = 1;
               WriteNum = 32;
               TransNum = 0;
               ftStatus = FT_Write(ftHandle,pmcombuf,WriteNum,&TransNum);   // QލđM
           }
           if(startpmpr > 100){                  // Ӱ݈ʒuǎJnςӰݺ۰׈ʒuMȂװ
               startpmpr = 1;
               WriteNum = 32;
               TransNum = 0;
               ftStatus = FT_Write(ftHandle,ppcombuf,WriteNum,&TransNum);   // qލđM
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           SetTimer(hwnd, ID_TIMER, 10, NULL);   // 10msecϰݒ
           break;

    case WM_PAINT:                           // IME ON  OFF łĂ΂
           hDc = BeginPaint(hwnd, &ps);          // WNDCLASS  hbrBackground ŕ`悳
                                                 // (InitApplication֐Őݒς)
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           sprintf_s(buf,128," >>                                  "); // \̈ر
           TextOut(hDc,10,20,buf,strlen(buf));
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           EndPaint(hwnd, &ps);
           break;

    case WM_DESTROY:                         // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           DAE350close();                        // DACS-E350̃f[^]vOIBDACS-E350 close

           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           return(DefWindowProc(hwnd, message, wParam, lParam));
           break;
  }

  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : int DAE350open(void)
   Ұ : Ȃ  
      : DACS-E350 OPENB DACS-E350̃f[^]vON
   ߂l :  0   OPENװ -1   f[^]vONُ -2
******************************************************************************/

int DAE350open(void)
{
    DWORD       TransNum;
    DWORD       ReadNum, RecNum, EventDword;
    DWORD       devIndex;
    char        buf[2048];
    char        serbuf[16];
    int         r;

    numDevs = 0;
    for(r=0; r!=5; r++){
        ftStatus = FT_ListDevices(&numDevs,NULL,FT_LIST_NUMBER_ONLY);  // *   ޲ڸĔײފ֐ FT_ListDevices           *
        if(numDevs > 0) break;
        Sleep(200);
    }
    if(numDevs > 1) numDevs = 1;          // ڑ޲ő吔1ɐ
    if(numDevs < 1) return(-1);           // ڑ޲0̂Ƃ͏I

    devIndex = 0;
    for(r=0; r!=5; r++){
        ftStatus = FT_ListDevices((PVOID)devIndex,serbuf,FT_LIST_BY_INDEX|FT_OPEN_BY_SERIAL_NUMBER);
                                          // serbuf ޲̼رٔԍ擾
        if(ftStatus == FT_OK) break;
        Sleep(200);
    }
    if(ftStatus == FT_OK){
        for(r=0; r!=5; r++){
            ftStatus = FT_OpenEx(serbuf,FT_OPEN_BY_SERIAL_NUMBER,&ftHandle);  // رٔԍ޲OPEN
            if(ftStatus == FT_OK) break;
            Sleep(200);
        }
    }
    if(ftStatus == FT_OK){
        ftStatus = FT_SetBaudRate(ftHandle,115200);     // ʐMxݒ(̼رْʐMɕKv)*
        ftStatus = FT_SetDataCharacteristics(ftHandle,FT_BITS_8,FT_STOP_BITS_1,FT_PARITY_NONE);
                                                        // ʐMް`ݒ(̼رْʐMɕKv)
        ftStatus = FT_SetFlowControl(ftHandle,FT_FLOW_XON_XOFF,0x11,0x13);
                                                        // ʐM۰ݒ(̼رْʐMɕKv)
        ftStatus = FT_SetChars(ftHandle,0x0d,1,0x0,0);  // ĕ(CR)ݒ
        ftStatus = FT_SetTimeouts(ftHandle,100,100);    // MѱĐݒ
    }
    if(ftStatus != FT_OK){
        ftStatus = FT_Close(ftHandle);                  // ޲CLOSE
        return(-1);
    }

    do{                                                 // DACS-E350-STDbootɏo͂үނj
        Sleep(1000);
        FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
        if(ReadNum > 2000) ReadNum = 2000;              // Mő吔2000byteɐ
        if(ReadNum > 0) ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);   // Mj
    }while(ReadNum > 0);

    TransNum = 0;
    sprintf_s(buf,128,"root");                          // DACS-E350 root Login
    buf[4] = 0xd;
    ftStatus = FT_Write(ftHandle,buf,5,&TransNum);      //  root 𑗐M
    Sleep(500);
    FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
    if(ReadNum > 1000) ReadNum = 1000;                  // Mő吔1000byteɐ
    if(ReadNum > 0) ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);   // M

    if(ReadNum > 15){
        if((buf[ReadNum-2] != '#') || (buf[ReadNum-16] != 'r'))
            ReadNum = 0;                                // LOGINłȂƂAM0Ƃ
    }

    if(ReadNum < 16){                                   // LOGINłȂƂ
        sprintf_s(buf,128,"reset");                     // DACS-E350 reset
        buf[5] = 0xd;
        ftStatus = FT_Write(ftHandle,buf,6,&TransNum);  //  reset 𑗐M
        Sleep(1000);
        ftStatus = FT_Close(ftHandle);                  // ޲CLOSE
        return(-2);
    }

    TransNum = 0;
    sprintf_s(buf,128,"stty -echo");                    // LinuxWo̴͂ޯ𖳌ɂ
    buf[10] = 0xd;
    ftStatus = FT_Write(ftHandle,buf,11,&TransNum);     //  stty -echo 𑗐M
    Sleep(100);
    FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
    if(ReadNum > 1000) ReadNum = 1000;                  // Mő吔1000byteɐ
    ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);   // M

    TransNum = 0;
    sprintf_s(buf,128,"./dae350_l_std");                // DACS-E350̑MvON
    buf[14] = 0xd;
    ftStatus = FT_Write(ftHandle,buf,15,&TransNum);     //  ./dae350_l_std 𑗐M

    return(0);
}

/******************************************************************************
   ֐   : void DAE350close(void)
   Ұ : Ȃ  
      : DACS-E350̃f[^]vOIBDACS-E350 close
   ߂l : Ȃ
******************************************************************************/

void DAE350close(void)
{
    DWORD       TransNum;
    DWORD       ReadNum, RecNum, EventDword;
    char        buf[1024];

    TransNum = 0;
    buf[0] = '*'; buf[1] = 0xd;           // Iނ𑗐MāADACS-E350̑MvOI
    ftStatus = FT_Write(ftHandle,buf,2,&TransNum);
    Sleep(200);
    FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
    if(ReadNum > 1000) ReadNum = 1000;    // Mő吔1000byteɐ
    if(ReadNum > 1) ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);  // Mްǐ؂

    TransNum = 0;
    buf[0] = 0x1a;                        // Iނ𑗐MāADACS-E350̑MvOI
    ftStatus = FT_Write(ftHandle,buf,1,&TransNum);
    Sleep(200);
    FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
    if(ReadNum > 1000) ReadNum = 1000;    // Mő吔1000byteɐ
    if(ReadNum > 1) ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);  // Mްǐ؂

    TransNum = 0;
    sprintf_s(buf,128,"stty echo");       // LinuxWo̴͂ޯLɂ(ɖ߂)
    buf[9] = 0xd;
    ftStatus = FT_Write(ftHandle,buf,10,&TransNum);
    Sleep(200);
    FT_GetStatus(ftHandle,&ReadNum,&TransNum,&EventDword);
    if(ReadNum > 1000) ReadNum = 1000;      // Mő吔1000byteɐ
    if(ReadNum > 1) ftStatus = FT_Read(ftHandle,buf,ReadNum,&RecNum);  // Mްǐ؂

    ftStatus = FT_Close(ftHandle);        // ޲CLOSE

    return;
}

/******************************************************************************
   ֐   : int hextobin(int num,char *buf)
   Ұ : num HEXް
            *str HEXް  
      : HEXintɕϊ
   ߂l : ϊbinaryް   ُ̂Ƃ-1
******************************************************************************/

int hextobin(int num, char *buf)
{
    char  datatmp;
    int   cnt, tmp;
    int   ret = 0;

    if(num < 1) return(-1);
    for(cnt = 0; cnt != num; cnt++){
        datatmp = buf[cnt];
        tmp = -1;
        if((datatmp > 0x2f) && (datatmp < 0x3a)) tmp = datatmp - 0x30;
        if((datatmp > 0x40) && (datatmp < 0x47)) tmp = datatmp - 0x41 + 10;
        if(tmp == -1) return(-1);
        else          ret = ret*16 + tmp; 
    }
    return(ret);
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}

/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
