/*****************************************************************************
 *****************************************************************************

 DACS-2500KB counter data read/write      D25KBsub.C

 JE^v\tg CPR25KB ƘAgāA
 (1) t@C(CPR25KBCN.csvACPR25KBDI.csv)ɂāA
                    JE^lуfW^͒lAēǎ
 (2) t@Co(CPR25KBDO.csv)ɂāAfW^o͂w肷
     L[͂ɂ16i6̃fW^o̓f[^w
      A1BD78(enter)   擪 bit23--20  -->  6 bit3--0
     0`9AA`F ȊO̕w肵ꍇ́AỸfW^o͕ύXȂ

                                          _bNXZ  2022/12/07

******************************************************************************
*****************************************************************************/

// P   VC2022p                                            2023/11/20

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "resource.h"

#define   ID_TIMER   1                           // ϰID

int     WINAPI   WinMain(_In_ HINSTANCE, _In_opt_  HINSTANCE, _In_ LPSTR, _In_ int);
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

void             Crt_GetDC      (void);
void             Crt_ReleaseDC  (void);

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int       Strh    = 16;                          // 
int       Strw    =  8;                          // 
char     *Strfont = "lr SVbN";             // (޼)"

char      kinbuf[32];                            // ޯ̧
int       kincnt  = 0;                           // ͐
FILE      *fp;

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(_In_ HINSTANCE hCurInst, _In_opt_  HINSTANCE hPrevInst, _In_ LPSTR lpCmdLine, _In_ int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);// ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  HWND   hwnd;                                   // 쐬Ҳݳ޳
  char   buf[128];

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd  = CreateWindow (cName,                   // ޳׽       (RegisterClassœo^O)
                        "DACS-2500KB counter data read/write",
                                                 // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        660,                     //    ̏l     (CW_USEDEFAULT)
                        400,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd    = hwnd;                                // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);
  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  TextOut(hDc,10,60,"  >> _              ",26);
  TextOut(hDc,203,120,"| Dout |",8);
  if(fopen_s(&fp,"CPR25KBDO.csv","rt") == 0){    // ASCII read OPEN
      if((fgets(buf, 16, fp)) != NULL){          // ޼ُoްǎ
          fclose(fp);                            // ̧قCLOSE
          TextOut(hDc,210,140,buf,6);            // ޼ُoް\
	  }
  }
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
  SetTimer(hwnd, ID_TIMER, 100, NULL);           // 100msecϰݒ
  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  PAINTSTRUCT  ps;
  int r;
  char buf[1024]; 

  switch(message)
  {
   case WM_COMMAND:                           // *** ޑ ***
           switch(LOWORD(wParam)){
             case ID_EXIT : DestroyWindow(hwnd); break;
                                                 // ۸яI
             default      : return(DefWindowProc(hwnd, message, wParam, lParam));
                             break;
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***
           switch(wParam){
               case 0x1b:                        // ESC ̂Ƃر
                   kincnt = 0;
                   break;
               case 0x08:                        // BS ̂Ƃ-1
                   kincnt = kincnt - 1;
                   break;
               default :                         // ްi[
                   kinbuf[kincnt] = wParam;
                   kincnt = kincnt + 1;
                   break;
           }
           if(kincnt < 0) kincnt = 0;            // ͐𐧌
           if(kincnt > 14) kincnt = 14;
           kinbuf[kincnt] = '_';                 // وʒu\pLǉ
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           TextOut(hDc,10,60,"  >>                ",26);
           TextOut(hDc,100,60,kinbuf,kincnt+1);  // ̓f[^\

           if(wParam == 0xd){                    // Enter ̂Ƃ
               if(kincnt !=0){
                   TextOut(hDc,10,60,"  >> _                  ",30); // ͕\̈ر
               }
               if(kincnt == 7){
                   kinbuf[6] = '\n';
                   if(fopen_s(&fp,"CPR25KBDO.csv","wt") == 0){  // ASCII write OPEN
                       fputs(kinbuf, fp);        // ޼ُoް(O۸їp)̧قɏ
                       fclose(fp);               // ̧قCLOSE
                       TextOut(hDc,203,120,"| Dout |",8);
                       TextOut(hDc,210,140,kinbuf,6);   // ޼ُoް\
                   }
               }
               kincnt = 0;
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           break;

    case WM_TIMER:                            // *** ݒ莞 ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           Crt_GetDC();                                 // DC̏ݒ (,,׼ = )
           TextOut(hDc,10,120,"|  Din |wait|",13);
           TextOut(hDc,10,180,"|    ch0    |    ch1    |    ch2    |    hd0    |    hd1    |    hd2    |",73);
           TextOut(hDc,10,240,"|    ch3    |    ch4    |    ch5    |    hd3    |    hd4    |    hd5    |",73);

           for(r = 0; r != 4; r++){
               if(fopen_s(&fp,"CPR25KBDI.csv","rt") == 0){  // ASCII read OPEN
                   if((fgets(buf, 16, fp)) != NULL){        // ޼ٓްǎ
                       TextOut(hDc,16,140,buf,8);           // ޼ٓް\
                   }
                   fclose(fp);                   // ̧قCLOSE
                   break;
               }
               Sleep(100);
           }
           if(r == 4) TextOut(hDc,16,140,"        ",8); // ްȂƂ\

           for(r = 0; r != 4; r++){
               if(fopen_s(&fp,"CPR25KBCN.csv","rt") == 0){  // ASCII read OPEN
                   if((fgets(buf, 256, fp)) != NULL){       // ްǎ
                       TextOut(hDc,16,200,buf,71);          //  ch0`2 ް\
                       TextOut(hDc,16,260,&buf[72],71);     //  ch3`5 ް\
                   }
                   fclose(fp);                   // ̧قCLOSE
                   break;
               }
               Sleep(100);
           }
           if(r == 4){                           // ްȂƂ\
               TextOut(hDc,16,200,"                                                                       ",71);
               TextOut(hDc,16,260,"                                                                       ",71);
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )

           SetTimer(hwnd, ID_TIMER, 125, NULL);  // 125msecϰݒ
           break;

    case WM_PAINT:                            // *** IME ON  OFF łĂ΂ ***
           hDc = BeginPaint(hwnd, &ps);          // WNDCLASS  hbrBackground ŕ`悳
                                                 // (InitApplication֐Őݒς)
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           EndPaint(hwnd, &ps);
           break;

    case WM_DESTROY:                          // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI
           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           return(DefWindowProc(hwnd, message, wParam, lParam));
           break;
  }

  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}

/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
