# DACS-2500KB データ送受信プログラム
# ID番号を使用して最大4台までの複数ボードを識別

# Windows11/10(64bit) 、Python 3 にて動作
# DdioM.py と FT.py を同じディレクトリに格納

import FT
handletbl = []                  # デバイスハンドルテーブル
IDnumtbl = ['Z','Z','Z','Z']    # ID番号テーブル

def DdioM_initID():
# 関数 デバイスのOPEN
#    戻り値 : OPENしたデバイス数、ID番号テーブル

    ret = [0,'Z','Z','Z','Z']   # 仮に接続デバイスなしとする
    for cnt in range(4):        # 4デバイス分の検索
        handle = FT.init_dacs(cnt)
        handletbl.append(handle)   # デバイスハンドルテーブルに追加
        if handle.value != None:   # デバイスありのとき
            # ROM読取りを実行してID番号確認
            readdata = FT.transfer_dacs(handle, '*$200000'+chr(0xd), 9)
            if (len(readdata) == 9) and (readdata[0:1] == '^'):
                IDnumtbl[cnt] = readdata[1:2]
                ret[cnt+1] = IDnumtbl[cnt]  # ID番号テーブルにID番号セット
                ret[0] += 1        # 接続デバイス数を更新
            else:
                FT.close_dacs(handle)   # 応答がない場合はデバイスをCLOSE
    return ret

def DdioM_write(tdata):
# 関数 コマンド送信とレスポンス受信
#    引数   : コマンドデータ文字列
#    戻り値 : 正常時 受信データ文字列
#             異常時 ID番号不適切 'Z'
#                    コマンドデータエラー ''

    seOK = 0                # 仮に該当するデバイスなしとする
    rdata = ''              # 仮に受信データなしとする
    if len(tdata) > 2:
        bdID = tdata[1:2]   # 指定したID番号を取得
        for cnt in range(4):  # ID番号テーブルを検索
            if bdID == IDnumtbl[cnt]:
                handle = handletbl[cnt]
                seOK = 1    # 該当するデバイスあり
                break
    if seOK == 0:           # ID番号不適切
        rdata = 'Z'
    elif len(tdata) > 3:
        ednum = FT.transfer_dacs3(handle)   # 残留データ消去
        num = tdata.count('&') + 1          # コマンド数取得
        # コマンド送信とレスポンス受信
        rdata = FT.transfer_dacs2(handle, tdata, num*9)
    return rdata

def DdioM_close():
# 関数 デバイスをCLOSE
#    引数   : なし
#    戻り値 : なし

    for cnt in range(4):
        if IDnumtbl[cnt] != 'Z':
            FT.close_dacs(handletbl[cnt])
