# DACS-2500KB サンプルプログラム
# ID番号を使用して最大4台までの複数ボードを識別

# Windows11/10(64bit) 、Python 3 にて動作
# DACS USBデバイスドライバをインストール済とします。
# DdioM_sample.py、DdioM.py、FT.py を同じディレクトリに格納

# デバイスをUSBポートに接続
# DdioM_sample.py を起動すると
#     接続しているすべてのDACS-2500KBデバイス(最大4台)をOPENし、
#     コマンドデータのキー入力待ちになります。
# -(マイナス) enter にてプログラム終了

import DdioM
import time

# デバイスをOPEN、DACS-2500KBボードを確認
ret = DdioM.DdioM_initID() # ボードを検索
if ret[0] != 0:            # 接続デバイスあり
    # 接続デバイス数とデバイスハンドル順にID番号を表示
    print(ret[0],'device',' ID =',ret[1],ret[2],ret[3],ret[4],)
else:                      # 接続デバイスなし
    print('no device')
    time.sleep(3)
    exit()

# キー入力とコマンド送信を繰返す
while True:
    kydatabuf = input('keyin = ')
    if kydatabuf == '-':          # マイナスキー入力のときは終了
        break
    # コマンド送信とレスポンス受信
    tdata = kydatabuf + chr(0xd)  # コマンド末尾にCRコードを追加
    rdata = DdioM.DdioM_write(tdata)  # コマンド送信とレスポンス受信
    # 応答結果を表示
    if rdata == 'Z':              # ID番号エラー
        print('ID number error')
    elif len(rdata) == 0:         # コマンドデータエラー
        print('command data error')
    else:
        print(rdata)              # 受信したレスポンスを表示
    continue

# デバイスをCLOSE
DdioM.DdioM_close()
