import FT26_rpi

# デバイスをOPEN
handle = FT26_rpi.init_dacs26(0)
if handle.value == None:
    print('no device')
    exit()

while True:
    # 送信データをキー入力
    kydata = input('keyin = ')
    if len(kydata) == 0:             # enterのみのとき
        break                        #     プログラム終了
    try:
        a = int(kydata,10)           # 10進文字列をintに変換
    except:
        a = -1
    if a <= 255 and a >=0:           # 0～255 正常データ
        print('        ' + "{:08b}".format(a)) # 2進数表示
    else:                            # 不正データ
        print('        invalid data')
        continue

    # 送信と受信 (送信データ(a)/受信データ(r)共に整数 0～255)
    r = FT26_rpi.transfer_dacs26(handle, a)
    if r >= 0:                       # 正常受信のとき
        print('    --> ' + "{:d}".format(r))   # 受信データを10進数表示
        print('        ' + "{:08b}".format(r)) # 2進数表示
    else:
        print('        ' + 'time-out')  # タイムアウトのとき

# デバイスをCLOSE
FT26_rpi.close_dacs26(handle)
