# DACS-9600BT 送受信テストプログラム 2

import serial
import msvcrt
import time

# COMポート検索

for reserch in range(2):
  for cnt in range(7):
    comnum = 'COM' + chr(0x33+cnt)     # COM3－>COM9を検索
    print(comnum + ' check',end='\r')
    ser = ''                           # 仮に無効なCOMとする
    try:                               # COMを準備
        ser = serial.Serial(comnum,115200,timeout=5,writeTimeout=10)
    except:
        time.sleep(0.1)
        continue                       # エラーなら次の検索へ
    try:                               # Wコマンドを送信してみる
        ser.write(('W0' + chr(0xd)).encode('ascii'))
    except:                            # エラーならCOMを閉じて次の検索へ
        ser.close()
        ser = ''
        continue
    time.sleep(1)                      # 送信できたとき
    dlen = ser.inWaiting()             # 応答を受信する
    data = ser.read(dlen)
    if dlen > 8:                       # byte数が9以上のとき(残留データを含むので)
        if data[dlen-1] == 0xd and data[dlen-9] == 0x52:  # 先頭がR文字のとき
            break                      #     検索OKにて終了
    ser.close()                        # 無応答ならCOMを閉じて次の検索へ
    ser = ''
  if ser != '':
    break                              # 検索OKにて再検索なし

# COMポート検索結果を表示

if ser == '':
    print('no device  ')
else:
    print(comnum + ' connect')
    print('keyin = ',end='\r')

# キー入力データを送信し、応答を受信
#     enterキーのみを入力するまで繰返し

while ser != '':
    if msvcrt.kbhit():                        # キー入力あり?
        kdata = input('keyin = ') + chr(0xd)  # 入力データを送信
        if len(kdata) < 2:                    # enterのみのときは終了
            ser.close()
            ser = ''
            break
        wdata = kdata.encode('ascii')         # 送信用にbyteデータに変換
        ser.write(wdata)                      # 送信
    dlen = ser.inWaiting()                    # 受信データ数を確認
    if dlen > 0:                              # 受信データありのとき
        data = ser.read(dlen)                 # 受信
        if data[dlen-1] != 0xd:               # 最後がCRでないとき
            time.sleep(0.01)                  # 少し時間をおいて
            dlen = ser.inWaiting()            # 残りのデータ数を確認
            if dlen > 0:                      # 残りのデータありのとき
                data = data + ser.read(dlen)  # 受信して前のデータに追加
        rdata = (data.decode('ascii'))        # 表示用として文字に変換
        print(rdata)                          # 受信データを表示
    time.sleep(0.01)
