/*****************************************************************************
 *****************************************************************************


 DACS-9600N-CNT  ý۸  D96NCNT.CPP

                                          _bNXZ  2023/09/14

******************************************************************************
*****************************************************************************/

#include <windows.h>
#include <stdio.h>
#include <winsock.h>
#include <memory.h>
#include <string.h>
#include <thread>
#include "resource.h"
#define   ID_TIMER   1                           // ϰID

int     WINAPI   WinMain        (HINSTANCE ,HINSTANCE ,LPSTR ,int );
BOOL             InitApplication(HINSTANCE );
BOOL             InitInstance   (HINSTANCE ,int );
LRESULT CALLBACK MainWndProc    (HWND ,UINT,WPARAM , LPARAM );

int              hextobin(int, char *);
void             Crt_GetDC      (void);
void             Crt_ReleaseDC  (void);

HANDLE    hInst;                                 // ݂̲ݽݽ       
HWND      hWnd;                                  // ޳           
HACCEL    hAccel;                                // ڰ          
HDC       hDc;                                   // CRT޲÷  
HPEN      hPen  ,hOldPen;                        //               
HBRUSH    hBrush,hOldBrush;                      // ׼             
HFONT     hFont ,hOldFont;                       //              
HRGN      hRgn;                                  // دݸذޮ   
char     *cName = "WIN32CLASS";                  // ޳׽

COLORREF ColorTbl[8] =  {  //   R   G   B
                          RGB(  0,  0,  0),      //  0 
                          RGB(  0,  0,255),      //  1 
                          RGB(  0,255,  0),      //  2 
                          RGB(  0,255,255),      //  3 
                          RGB(255,  0,  0),      //  4 
                          RGB(255,  0,255),      //  5 
                          RGB(255,255,  0),      //  6 
                          RGB(255,255,255),      //  7 
                        };

int    Strh    = 16;                             // 
int    Strw    =  8;                             // 
char  *Strfont = "lr SVbN";                // (޼)"

char   kinbuf[128];                              // ޯ̧
int    kincnt  = 0;                              // ͐
int    kincomm = 0;                              // ͺޑMv
int    autocomm = 0;                             // lǎM҂
int    timeoutcnt = 0;                           // MѱĶ
char   recbuf[16384];                            // Mް

WSADATA wsaData;                                 // ȯܰ֘A
SOCKET sock;
struct sockaddr_in D96N;
int    sconnectf  = 0;                           // ڑ :1 ُ:0
FILE   *fp;

/******************************************************************************
   ֐   : int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
   Ұ : hCurInst  ݂̲ݽݽ
            hPrevInst O̲ݽݽ
            lpCmdLine ײ݂ݸ߲
            iCmdShow  ޳̕\Ԓl
      : ֐̌ĂяoƃbZ[W[v
******************************************************************************/

int WINAPI WinMain(HINSTANCE hCurInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int iCmdShow)
{
  MSG msg;                                       // үލ\

  if(!hPrevInst)                                 // hPrevInst ͏ NULL Ԃ
 
  if(!InitApplication(hCurInst))                 // ޳̓o^
      return(FALSE);                             // o^sȂΏI
 
  if(!InitInstance(hCurInst, iCmdShow))          // ޳̍쐬/\
    return(FALSE);                               // 쐬sȂ͏I

  while(GetMessage(&msg, NULL, 0, 0))            // үނ̎擾
  {
      TranslateMessage(&msg);                    // үނ̕ϊ
      DispatchMessage (&msg);                    // үނި߯
  }

  return(msg.wParam);                            // PostQuitMessage Őݒ肳ꂽlԂI
}

/******************************************************************************
   ֐   : BOOL InitApplication(HINSTANCE hCurInst)
   Ұ : hCurInst ݂̲ݽݽ
      : ޳ް̏Ƴ޳׽̓o^
******************************************************************************/

BOOL InitApplication(HINSTANCE hCurInst)
{
  WNDCLASS wc;                                   // ޳׽\

  wc.style         = CS_DBLCLKS;                 // ׽ ٸدgp(ݸق̂=0)
  wc.lpfnWndProc   = MainWndProc;                // ޳֐
  wc.cbClsExtra    = 0;                          // ǉ׽ް
  wc.cbWndExtra    = 0;                          // ǉ޳ް
  wc.hInstance     = hCurInst;                   // ݂̲ݽݽ
  wc.hIcon         = LoadIcon  (hCurInst, IDI_APPLICATION);// ޳Ŏgp鱲
  wc.hCursor       = LoadCursor(NULL, IDC_ARROW);          // ޳Ŏgp鶰
  wc.hbrBackground = (struct HBRUSH__ *)GetStockObject(WHITE_BRUSH);// wiƂȂF
  wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU);  // ƭ NULL
  wc.lpszClassName = cName;                      // ޳׽

  return(RegisterClass(&wc));                    // ޳׽̓o^̌ʂԂ
}
 
/******************************************************************************
   ֐   : BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
   Ұ : hCurInst ݂̲ݽݽ
            iCmdShow ޳̕\Ԓl
      : ݽݽق̕ۑƳ޳̍쐬
******************************************************************************/

BOOL InitInstance(HINSTANCE hCurInst,int iCmdShow)
{
  HWND   hwnd;                                   // 쐬Ҳݳ޳
  char   buf[2048], IPfixadd[64];
  int    q, l;
  const int socknoini = 0x2616;                  // Ĕԍ
  unsigned long val  = 1;

  hInst = hCurInst;                              // ݂̲ݽݽ̕ۑ
                                                 // ޳̍쐬
  hwnd = CreateWindow  (cName,                   // ޳׽       (RegisterClassœo^O)
                        "DACS-9600N JE^eXgvO", // ްɕ\镶
                        WS_OVERLAPPEDWINDOW,     // ޳        (WS_OVERLAPPEDWINDOW,WS_POPUP)
                        CW_USEDEFAULT,           // XW̏l     (CW_USEDEFAULT)
                        CW_USEDEFAULT,           // YW̏l     (CW_USEDEFAULT)
                        600,                     //    ̏l     (CW_USEDEFAULT)
                        450,                     //  ̏l     (CW_USEDEFAULT)
                        NULL,                    // e޳          ()
                        NULL,                    // ƭ              ()
                        hCurInst,                // ݂̲ݽݽ
                        NULL                     // ޳쐬̏(sv)
                       );

  if(!hwnd)                                      // ޳͍쐬ꂽ?
    return(FALSE);                               // ޳쐬s(FALSE)Ԃ

  hWnd = hwnd;                                   // Oϐɺ߰  
  ShowWindow  (hwnd, iCmdShow);
  UpdateWindow(hwnd);

  // ȯܰڑ

  sconnectf = 0;                                 // ɐڑُƂ

  WSAStartup(MAKEWORD(2,0), &wsaData);           // LANʐM̏
  
  // ȯܰݒ̧قɋLqĂIPڽo

  l = 0;
  if(fopen_s(&fp,"DACS9600NB.col","rt") == 0){   // ASCII READ OPEN
      for(l = 0; l != 8; l++){                   // 8sڂ܂œǂݔ΂
          if(fgets(IPfixadd, 50, fp) == NULL) break;
      }
      fclose(fp);
  }
  q = 0;
  if(l == 8){
      for(q = 0; q != 16; q++){                  // 8sڂIPڽo
          if(((IPfixadd[q] < '0') || (IPfixadd[q] > '9')) && (IPfixadd[q] != '.')) break;
      }
  }
  if((q > 6) && (q < 16)) IPfixadd[q] = NULL;
  else l = sprintf_s(IPfixadd,128,"192.168.69.10");  // ްȂƂIPڽɏl

  Crt_GetDC();                                   // DC̏ݒ (,,׼ = )
  l = sprintf_s(buf,128,"  %s ڑmF                            ", IPfixadd);
  TextOut(hDc,10,20,buf,l);
  Crt_ReleaseDC();                               // DC̏Iݒ (,,׼ = )
 
  std::this_thread::sleep_for(std::chrono::milliseconds(500)); // 500msec҂

  // ڑĉmF

  sock = socket(AF_INET, SOCK_STREAM, 0);        // Ă̍쐬
  if(sock != INVALID_SOCKET){
      D96N.sin_family = AF_INET;
      D96N.sin_port = htons(socknoini);          // ߰Ĕԍݒ
      if((D96N.sin_addr.S_un.S_addr = inet_addr(IPfixadd)) != INADDR_NONE){
                                                 // IPڽ2iɕϊ
          connect(sock, (struct sockaddr *)&D96N, sizeof(D96N));   // ڑ
          ioctlsocket(sock, FIONBIO, &val);      // ްMۯݸސݒƂ
          std::this_thread::sleep_for(std::chrono::milliseconds(500));   // 500msec҂
          sprintf_s(buf,128,"W0              "); // W(ڑmFp)
                                                 // ]Ƚ߰(ް)
                                                 // ް𑝂₷
          buf[2] = 0xd;
          send(sock, buf, 16, 0);                // ްM
          std::this_thread::sleep_for(std::chrono::milliseconds(500));
          l = recv(sock, buf, 2048, 0);
          if(l > 0) sconnectf = 1;               // ɐڑł
          else closesocket(sock);                // ڑȂƂͿĂ
      }
  }
  SetTimer(hwnd, ID_TIMER, 100, NULL);           // 100msecϰݒ
  return(TRUE);                                  // ޳쐬(TRUE)Ԃ
}

/******************************************************************************
   ֐   : LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
   Ұ : hwnd     ޳
            message  ү
            wParam   ܰޒlүޕt
            lParam   ݸޒlүޕt
      : үޏ
            ү : WM_COMMAND  - ƭү
                     WM_CREATE   -
                     WM_PAINT    - ޳̍XV
                     WM_DESTROY  - ޳̔j
******************************************************************************/

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
  PAINTSTRUCT ps;
  char buf[2048], txbuf[256];
  int l, r, cno;
  int recnum;

  switch(message){
    case WM_COMMAND:                          // *** ޑ ***
           switch(LOWORD(wParam)){
               case ID_EXIT : DestroyWindow(hwnd); break;   // ۸яI
           }
           break;

    case WM_CHAR:                             // *** ͂Ƃ̏ ***

           if(sconnectf != 1) break;             // ڑُ̂Ƃ͂ȂɂłȂ

           KillTimer(hwnd, ID_TIMER);            // ϰI
           switch(wParam){
               case 0x1b:                        // ESC ̂Ƃر
                   kincnt = 0;
                   break;
               case 0x08:                        // BS ̂Ƃ-1
                   kincnt = kincnt - 1;
                   break;
               default :                         // ްi[
                   kinbuf[kincnt] = wParam;
                   kincnt = kincnt + 1;
                   break;
           }
           if(kincnt < 0) kincnt = 0;            // ͐𐧌
           if(kincnt > 48) kincnt = 48;
           kinbuf[kincnt] = '_';                 // وʒu\pLǉ

           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           l = sprintf_s(buf,128," >>                                                               "); // \̈ر
           TextOut(hDc,10,60,buf,l);
           TextOut(hDc,100,60,kinbuf,kincnt+1);  // ̓f[^\

           if(wParam == 0xd){                    // Enter ̂Ƃ
               if(kincnt > 1) kincomm = 1;       // ͺޑMvON
           }
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           SetTimer(hwnd, ID_TIMER, 100, NULL);  // 100msecϰݒ
           break;

    case WM_TIMER:                           // *** ݒ莞 ***

           // ȯܰڑʂ̕\
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           if(sconnectf != 0) l = sprintf_s(buf,128,"ڑ  R}hL[͂Ă     ");
           else               l = sprintf_s(buf,128,"ڑł܂                               ");
           TextOut(hDc,10,20,buf,l);
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           if(sconnectf == 0) break;             // ڑȂƂ

           KillTimer(hwnd, ID_TIMER);            // ϰI

           // ްM

           recnum = recv(sock, recbuf, 8192, 2); // Mް̊mF (ۯݸ)
                                                 // Mްޯ̧Ɏc
           if(recnum >= 9){
               for(r = recnum-1; r >= 7; r--){   // ؂躰ނT
                   if((recbuf[r] == 0xd) || (recbuf[r] == '&')) break;
               }
               if(r >= 8) recnum = recv(sock, recbuf, r+1, 0); // ްM (ۯݸ)
           }                                     // Mްޯ̧ȂȂ

           // ͺނɑ΂Mް

           if((recnum > 8) && (kincomm > 1)){    // Mςް 9 ȏŁAͺނɑ΂鉞҂̂Ƃ
               if(recnum > 40){                  // MްƂ̏
                   recnum = 40;
                   recbuf[recnum-1] = '>';
               }
               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               TextOut(hDc,100,120,recbuf,recnum); // Mf[^\
               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )
               kincomm = 0;                      // ͺމ҂
               timeoutcnt = 0;                   // ѱĶؾ
           }

           // ̎Mް

           if((recnum > 52) && (autocomm == 1)){ // Mςް53ȏ̂Ƃ
               if((recbuf[0] == 'N') && (recbuf[2] == 'E') && (recnum == 53)){
                                                 // *** lްMƂ̏ ***
                   Crt_GetDC();                  // DC̏ݒ (,,׼ = )
                   for(cno = 0; cno != 6; cno++){
                       if(cno < 3) l = sprintf_s(buf," %1d >>               ",cno);
                       else        l = sprintf_s(buf,"ΰ%1d >>               ",cno-3);
                       TextOut(hDc,10,240+15*cno,buf,l);
                       TextOut(hDc,100,240+15*cno,&recbuf[4+cno*8],8);   // l\
                       r = hextobin(8, &recbuf[4+cno*8]);                // 16i𐮐lɕϊ
                       l = sprintf_s(buf," %12d ",r);
                       TextOut(hDc,170,240+15*cno,buf,l);                // l10i\
                   }
                   Crt_ReleaseDC();              // DC̏Iݒ (,,׼ = )
                   autocomm = 0;                 // lǎ҂
                   timeoutcnt = 0;               // ѱĶؾ
               }
           }

           // ް̑M

           if((kincomm == 1) && (autocomm == 0)){  // ް𑗐M
               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               TextOut(hDc,10,60,"  >> _                            ",40); // \̈ر
               TextOut(hDc,10,90,"M    >>                              ",40);
               l = sprintf_s(buf,128,"M    >>                                         ");
               TextOut(hDc,10,120,buf,l);

               // ްȂƂ̑΍
               //   LANٰɂĐڑؒf̂h
               //   ްɗ]Ƚ߰(ް)ǉ
 
               for(r = 0; r != 16; r++) buf[r] = ' ';
               for(r = 0; r != kincnt; r++) buf[r] = kinbuf[r];
               if(kincnt > 16) r = kincnt;
               else            r = 16;

               // M
               send(sock, buf, r, 0);            // ްM

               for(r = 0; r != kincnt; r++){
                   if(kinbuf[r] == 0xd) kinbuf[r] = '.';  // CRDɕςĕ\
               }
               TextOut(hDc,100,90, kinbuf, kincnt);  // Mް\

               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )
               if((kinbuf[1] == '4') || (kinbuf[1] == 'C') || (kinbuf[1] == 'c')) kincomm = 0;
                                                 // vȂ̂ƂAͺޑMvؾ
               else kincomm = 2;                 // v̂ƂAͺނɑ΂鉞҂Ƃ
               kincnt = 0;                       // ްؾ 
               timeoutcnt = 0;                   // ѱĶؾ
           }

           // ްMނ̎M

           if((autocomm == 0) && (kincomm == 0)){
               // *** Mނlǎ̂߂ɑM ***
               l = sprintf_s(txbuf,128,"M0E             ");  // MR}h
               txbuf[3] = 0xd;                   // CR޾
               send(sock, txbuf,16, 0);          // ްM
               autocomm = 1;                     // lǎ҂Ƃ
               timeoutcnt = 0;                   // ѱĶؾ
           }

           // MѱĊĎ

           timeoutcnt++;                         // MѱĶXV
           if(timeoutcnt > 200){                 // ̏
               timeoutcnt = 0;
               Crt_GetDC();                      // DC̏ݒ (,,׼ = )
               TextOut(hDc,10,20,"܂                                     ",53); // ѱĂ\
               Crt_ReleaseDC();                  // DC̏Iݒ (,,׼ = )
               autocomm = 0;                     // lǎ҂
               kincomm = 0;                      // ͺމ҂
           }
           SetTimer(hwnd, ID_TIMER, 100, NULL);  // 100msecϰݒ
           break;

    case WM_PAINT:                           // IME ON  OFF łĂ΂
           hDc = BeginPaint(hwnd, &ps);          // WNDCLASS  hbrBackground ŕ`悳
                                                 // (InitApplication֐Őݒς)
           Crt_GetDC();                          // DC̏ݒ (,,׼ = )
           Crt_ReleaseDC();                      // DC̏Iݒ (,,׼ = )
           EndPaint(hwnd, &ps);
           break;

    case WM_DESTROY:                         // *** ޳jү ***
           KillTimer(hwnd, ID_TIMER);            // ϰI

           closesocket(sock);                    // Ă
           WSACleanup();                         // LANʐMI

           PostQuitMessage(0);                   // WinMain֐үٰ߂𔲂鏈
           break;

    default:
           break;
  }
  return(DefWindowProc(hwnd, message, wParam, lParam));
}

/******************************************************************************
   ֐   : int hextobin(int num,char *buf)
   Ұ : num HEXް
            *str HEXް  
      : HEXintɕϊ
   ߂l : ϊbinaryް   ُ̂Ƃ-1
******************************************************************************/

int hextobin(int num, char *buf)
{
    char  datatmp;
    int   cnt, tmp;
    int   ret = 0;

    if(num < 1) return(-1);
    for(cnt = 0; cnt != num; cnt++){
        datatmp = buf[cnt];
        tmp = -1;
        if((datatmp > 0x2f) && (datatmp < 0x3a)) tmp = datatmp - 0x30;
        if((datatmp > 0x40) && (datatmp < 0x47)) tmp = datatmp - 0x41 + 10;
        if(tmp == -1) return(-1);
        else          ret = ret*16 + tmp; 
    }
    return(ret);
}

/******************************************************************************
   ֐   : void Crt_GetDC(void)
   Ұ : Ȃ
      : DC̏ݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_GetDC(void)
{
  hDc       = GetDC           (hWnd);
  hPen      = CreatePen       (PS_SOLID,1,ColorTbl[ 0]);
  hBrush    = CreateSolidBrush(           ColorTbl[ 0]);

  hFont     = CreateFont      (Strh,Strw,
                               0, 0,FW_NORMAL, FALSE, FALSE, 0,
                               SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS,
                               CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
                               DEFAULT_PITCH | FF_MODERN,Strfont);

  hOldPen   = (struct HPEN__ *)SelectObject(hDc,hPen  );
  hOldBrush = (struct HBRUSH__ *)SelectObject(hDc,hBrush);
  hOldFont  = (struct HFONT__ *)SelectObject(hDc,hFont );

  SetTextColor(hDc,ColorTbl[ 0]);                // F
  SetBkColor  (hDc,ColorTbl[ 7]);                // wiF ()
  SetBkMode(hDc,OPAQUE);                         // ㏑Ӱ
}

/******************************************************************************
   ֐   : void Crt_ReleaseDC(void)
   Ұ : Ȃ
      : DC̏Iݒ (,,׼ = )
   ߂l : Ȃ
******************************************************************************/

void Crt_ReleaseDC(void)
{
  SelectObject(hDc,hOldPen  );
  SelectObject(hDc,hOldBrush);
  SelectObject(hDc,hOldFont );

  DeleteObject(hPen  );
  DeleteObject(hBrush);
  DeleteObject(hFont );

  ReleaseDC(hWnd,hDc);
}

/******************************************************************************
                              BOTTOM    OF    FILE
******************************************************************************/
