import socket
import time

# TCP/IP ソケットオブジェクトの作成
d96wf = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
# タイムアウトの設定 10秒
d96wf.settimeout(10)

# DACS-9600KWF デバイスに接続
print('connection')           # 接続中を表示
try:
    d96wf.connect(('192.168.0.42', 0x2616))
except:
    print('connection error') # 接続エラー
    time.sleep(3)             # メッセージ表示時間
    exit()

while True:
    # 送信するコマンド文字列をキー入力
    writedata = input('keyin = ')
    if len(writedata) < 2: break
    print(writedata)

    # 送信する文字列にCRコードを追加
    # さらに、送信する文字数を増やすため無効なスペース(16個)を追加
    writedata = writedata + chr(0xd) + '                '

    # cp932文字列をASCII文字列に変換
    wdata = writedata.encode('ascii')

    # データ送信
    d96wf.sendall(wdata)
    
    # データ受信
    try:
        rdatabuf = d96wf.recv(1024)
    except:
        print('no return')    # タイムアウトエラー
        continue

    # ASCII文字列をcp932文字列に変換
    rdata = rdatabuf.decode('cp932')
    print(rdata)

d96wf.close()                 # 接続終了
print('end')
time.sleep(2)                 # メッセージ表示時間
